/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICENegociator {
    private static final int LOCAL_PREFERENCE = 0;
    private static final int SERVER_REFLEXIVE_PREFERENCE = 42;
    private static final int PEER_REFLEXIVE_PREFERENCE = 84;
    private static final int RELAYED_PREFERENCE = 126;
    private short componentId;
    List<Candidate> candidates;

    public ICENegociator(short componentId) {
        this.componentId = componentId;
        this.candidates = new ArrayList<Candidate>();
    }

    public void gatherCandidateAddresses() {
        int network = 0;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                while (iaddresses.hasMoreElements()) {
                    InetAddress iaddress = iaddresses.nextElement();
                    if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                    Candidate local = new Candidate(new Address(iaddress.getAddress()), this.componentId, network++);
                    this.candidates.add(local);
                    DiscoveryTest test = new DiscoveryTest(iaddress, "thiago", 3478);
                    DiscoveryInfo di = test.test();
                    if (di.getPublicIP() == null) continue;
                    Candidate cand = new Candidate(new Address(di.getPublicIP().getAddress()), Candidate.CandidateType.ServerReflexive, this.componentId, local, network++);
                    cand.setComponentId(this.componentId);
                    this.candidates.add(cand);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prioritizeCandidates() {
        int numberLocal = 0;
        int numberServerReflexive = 0;
        int numberPeerReflexive = 0;
        int numberRelayed = 0;
        for (Candidate cand : this.candidates) {
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                ++numberLocal;
                continue;
            }
            if (type == Candidate.CandidateType.ServerReflexive) {
                ++numberServerReflexive;
                continue;
            }
            if (type == Candidate.CandidateType.PeerReflexive) {
                ++numberPeerReflexive;
                continue;
            }
            if (type != Candidate.CandidateType.Relayed) continue;
            ++numberRelayed;
        }
        int z = 0;
        for (Candidate cand : this.candidates) {
            ++z;
            int typeValue = 0;
            int localValue = 0;
            short componentValue = 0;
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                typeValue = 0;
                localValue = numberLocal--;
            } else if (type == Candidate.CandidateType.ServerReflexive) {
                typeValue = 42;
                localValue = numberServerReflexive--;
            } else if (type == Candidate.CandidateType.PeerReflexive) {
                typeValue = 84;
                localValue = numberPeerReflexive--;
            } else if (type == Candidate.CandidateType.Relayed) {
                typeValue = 126;
                localValue = numberRelayed--;
            }
            componentValue = cand.getComponentId();
            int priority = 26 * typeValue + 10 * localValue + componentValue;
            cand.setPriority(priority);
        }
        System.out.println(z);
    }

    public List<Candidate> getSortedCandidates() {
        Vector<Candidate> sortedCandidates = new Vector<Candidate>(this.candidates);
        Collections.sort(sortedCandidates);
        return sortedCandidates;
    }

    public static void main(String[] args) {
        String first = "";
        try {
            int err = 0;
            for (int i = 0; i < 3; ++i) {
                ICENegociator cc = new ICENegociator(1);
                cc.gatherCandidateAddresses();
                cc.prioritizeCandidates();
                for (Candidate candidate : cc.getSortedCandidates()) {
                    try {
                        System.out.println("C: " + candidate.getAddress().getInetAddress() + "|" + candidate.getBase().getAddress().getInetAddress() + " p:" + candidate.getPriority());
                    }
                    catch (UtilityException e) {
                        e.printStackTrace();
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
                Candidate candidate = cc.getSortedCandidates().get(0);
                String temp = "C: " + candidate.getAddress().getInetAddress() + "|" + candidate.getBase().getAddress().getInetAddress() + " p:" + candidate.getPriority();
                if (first.equals("")) {
                    first = temp;
                }
                if (!first.equals(temp)) {
                    ++err;
                }
                first = temp;
                cc = null;
                Thread.sleep(10L);
            }
            System.out.println("Errors: " + err);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

