/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import net.sf.cindy.impl.AbstractSession;
import net.sf.cindy.impl.Constants;

public abstract class AbstractTimeoutSession
extends AbstractSession {
    private boolean established = false;
    private int idleTimes = 0;

    protected void dispatchSessionEstablished() {
        this.established = true;
        super.dispatchSessionEstablished();
    }

    protected void dispatchSessionClosed() {
        this.established = false;
        this.idleTimes = 0;
        super.dispatchSessionClosed();
    }

    public void onEvent(Object object, Object object2) {
        if (object == Constants.EV_CHECK_TIMEOUT) {
            this.checkTimeout((Integer)object2);
        } else if (object == Constants.EV_EVENT_HAPPEN) {
            this.eventHappen();
        }
        super.onEvent(object, object2);
    }

    private void checkTimeout(int n) {
        if (!this.established) {
            return;
        }
        if (this.getSessionTimeout() > 0) {
            this.idleTimes += n;
            if (this.idleTimes >= this.getSessionTimeout()) {
                this.dispatchSessionTimeout();
                this.idleTimes = 0;
            }
        }
        if (this.writeQueue.isEmpty()) {
            this.dispatchSessionIdle();
        }
    }

    private void eventHappen() {
        this.idleTimes = 0;
    }
}

