/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import net.sf.cindy.Message;
import net.sf.cindy.PacketMessage;
import net.sf.cindy.impl.AbstractSimulatedSession;
import net.sf.cindy.spi.SessionStatisticSpi;

public class SimulatedMulticastSession
extends AbstractSimulatedSession {
    private static final int MULTICAST_SOCKET_TIMEOUT = 100;
    private InetAddress multicastAddress;
    private int bindPort = -1;
    private MulticastSocket multicastSocket;
    private MulticastSocket socket;

    public void setBindPort(int n) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set multicast port after session started");
        }
        this.bindPort = n;
    }

    public void setMulticastAddress(InetAddress inetAddress) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set multicast address after session started");
        }
        this.multicastAddress = inetAddress;
    }

    public void setMulticastSocket(MulticastSocket multicastSocket) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set multicast socket after session started");
        }
        this.multicastSocket = multicastSocket;
    }

    public MulticastSocket getMulticastSocket() {
        if (this.socket != null) {
            return this.socket;
        }
        return this.multicastSocket;
    }

    public boolean isStarted() {
        return this.socket != null;
    }

    protected void doClose() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.multicastSocket = null;
    }

    protected void doStart() throws IOException {
        if (this.multicastSocket == null) {
            this.multicastSocket = this.bindPort >= 0 && this.bindPort <= 65535 ? new MulticastSocket(this.bindPort) : new MulticastSocket();
            if (this.multicastAddress != null) {
                this.multicastSocket.joinGroup(this.multicastAddress);
            }
        }
        this.multicastSocket.setSoTimeout(100);
        this.socket = this.multicastSocket;
    }

    protected void checkWriteToWriteQueue(Message message) throws IllegalArgumentException, IllegalStateException {
        super.checkWriteToWriteQueue(message);
        if (this.socket == null || this.socket.isClosed()) {
            throw new IllegalStateException("session is not available");
        }
        if (!this.socket.isConnected()) {
            if (message instanceof PacketMessage && ((PacketMessage)message).getSocketAddress() != null) {
                return;
            }
            throw new IllegalArgumentException("can't send message without socket address");
        }
    }

    protected Message receive() throws IOException {
        byte[] byArray = new byte[this.readBuffer.remaining()];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.receive(datagramPacket);
        if (this.getStatistic() != null) {
            ((SessionStatisticSpi)this.getStatistic()).received(datagramPacket.getLength());
        }
        this.readBuffer.put(byArray, 0, datagramPacket.getLength());
        this.readBuffer.flip();
        Message message = this.recognizeMessage(this.readBuffer);
        if (message != null && message instanceof PacketMessage) {
            ((PacketMessage)message).setSocketAddress(datagramPacket.getSocketAddress());
        }
        this.readBuffer.clear();
        return message;
    }

    protected void send(Message message) throws IOException {
        SocketAddress socketAddress = this.socket.getRemoteSocketAddress();
        if (socketAddress == null) {
            socketAddress = ((PacketMessage)message).getSocketAddress();
        }
        byte[] byArray = this.writeMessageToBytes(message);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length, socketAddress);
        this.socket.send(datagramPacket);
        if (this.getStatistic() != null) {
            ((SessionStatisticSpi)this.getStatistic()).sent(datagramPacket.getLength());
        }
    }

    private byte[] writeMessageToBytes(Message message) {
        ByteBuffer[] byteBufferArray = message.toByteBuffer();
        int n = 0;
        if (byteBufferArray != null) {
            for (int i = 0; i < byteBufferArray.length; ++i) {
                if (byteBufferArray[i] == null) continue;
                n += byteBufferArray[i].remaining();
            }
        }
        byte[] byArray = new byte[n];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBufferArray != null) {
            for (int i = 0; i < byteBufferArray.length; ++i) {
                if (byteBufferArray[i] == null) continue;
                byteBuffer.put(byteBufferArray[i]);
            }
        }
        return byArray;
    }
}

