/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.util.CustomCardLayout;
import com.install4j.runtime.wizard.WizardFrame;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class WizardBase
extends JPanel {
    private static final int FRAME_WIDTH = 600;
    private static final int FRAME_HEIGHT = 400;
    private static final int LAYOUT_GAP_WIDTH = 10;
    private static final int LAYOUT_GAP_HEIGHT = 0;
    private String title;
    private WizardFrame wizardFrame;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private List screens = new LinkedList();
    private ListIterator screenIterator;
    private boolean completed = false;

    public WizardBase(String string) {
        this.title = string;
        this.setupComponent();
    }

    public void showFrame(JFrame jFrame, ImageIcon imageIcon) {
        this.wizardFrame = new WizardFrame(this, jFrame);
        if (imageIcon != null) {
            this.wizardFrame.setIconImage(imageIcon.getImage());
        }
        this.setVisible(true);
    }

    public void showFrame(JFrame jFrame) {
        this.showFrame(jFrame, null);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public boolean nextScreen() {
        WizardScreen wizardScreen;
        do {
            if (this.screenIterator.hasNext()) continue;
            this.finish();
            return false;
        } while (!(wizardScreen = (WizardScreen)this.screenIterator.next()).supportsNext());
        wizardScreen.activate();
        return true;
    }

    public boolean previousScreen() {
        WizardScreen wizardScreen;
        if (!this.screenIterator.hasPrevious()) {
            return false;
        }
        this.screenIterator.previous();
        do {
            if (this.screenIterator.hasPrevious()) continue;
            return false;
        } while (!(wizardScreen = (WizardScreen)this.screenIterator.previous()).supportsPrevious());
        this.screenIterator.next();
        wizardScreen.activate();
        return true;
    }

    protected boolean isQuitOnWindowClose() {
        return true;
    }

    protected boolean setScreen(WizardScreen wizardScreen) {
        int n = this.screens.indexOf(wizardScreen);
        if (n < 0) {
            return false;
        }
        this.screenIterator = this.screens.listIterator(n);
        this.screenIterator.next();
        wizardScreen.activate();
        return true;
    }

    public void finish() {
        this.completed = true;
        this.beforeHide();
        this.setVisible(false);
    }

    public void activateScreen(WizardScreen wizardScreen) {
        this.cardLayout.show(this.cardPanel, wizardScreen.getName());
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.beforeShow();
            this.screenIterator = this.screens.listIterator();
            this.nextScreen();
            this.completed = false;
        }
        if (this.wizardFrame != null) {
            this.wizardFrame.setVisible(bl);
            if (!bl) {
                this.afterHide();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void quit() {
        this.completed = true;
        this.setVisible(false);
    }

    protected abstract void setupScreens();

    protected void beforeShow() {
    }

    protected void beforeHide() {
    }

    protected void afterHide() {
    }

    protected void registerScreen(WizardScreen wizardScreen) {
        if (wizardScreen != null) {
            this.cardPanel.add((Component)wizardScreen, wizardScreen.getName());
            this.screens.add(wizardScreen);
        }
    }

    protected int getFrameWidth() {
        return 600;
    }

    protected int getFrameHeight() {
        return 400;
    }

    protected void setupComponent() {
        this.cardLayout = new CustomCardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this.cardPanel, "Center");
    }
}

