/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import javax.sip.header.ContactHeader;

public abstract class MessageChannel {
    protected MessageProcessor messageProcessor;

    public abstract void close();

    public abstract SIPMessageStack getSIPStack();

    public abstract String getTransport();

    public abstract boolean isReliable();

    public abstract boolean isSecure();

    public abstract void sendMessage(SIPMessage var1) throws IOException;

    public abstract String getPeerAddress();

    protected abstract InetAddress getPeerInetAddress();

    protected abstract String getPeerProtocol();

    public abstract int getPeerPort();

    public abstract int getPeerPacketSourcePort();

    public abstract InetAddress getPeerPacketSourceAddress();

    public abstract String getKey();

    public abstract String getViaHost();

    public abstract int getViaPort();

    protected abstract void sendMessage(byte[] var1, InetAddress var2, int var3, boolean var4) throws IOException;

    public String getHost() {
        return this.getSIPStack().getHostAddress();
    }

    public int getPort() {
        if (this.messageProcessor != null) {
            return this.messageProcessor.getPort();
        }
        return -1;
    }

    public void sendMessage(SIPMessage sipMessage, InetAddress receiverAddress, int receiverPort) throws IOException {
        long time = System.currentTimeMillis();
        byte[] bytes = sipMessage.encodeAsBytes();
        this.sendMessage(bytes, receiverAddress, receiverPort, sipMessage instanceof SIPRequest);
        this.logMessage(sipMessage, receiverAddress, receiverPort, time);
    }

    public String getRawIpSourceAddress() {
        String sourceAddress = this.getPeerAddress();
        String rawIpSourceAddress = null;
        try {
            InetAddress sourceInetAddress = InetAddress.getByName(sourceAddress);
            rawIpSourceAddress = sourceInetAddress.getHostAddress();
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        return rawIpSourceAddress;
    }

    public static String getKey(InetAddress inetAddr, int port, String transport) {
        return (transport + ":" + inetAddr.getHostAddress() + ":" + port).toLowerCase();
    }

    public static String getKey(HostPort hostPort, String transport) {
        return (transport + ":" + hostPort.getHost().getHostname() + ":" + hostPort.getPort()).toLowerCase();
    }

    public HostPort getHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getHost()));
        retval.setPort(this.getPort());
        return retval;
    }

    public HostPort getPeerHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getPeerAddress()));
        retval.setPort(this.getPeerPort());
        return retval;
    }

    public Via getViaHeader() {
        Via channelViaHeader = new Via();
        try {
            channelViaHeader.setTransport(this.getTransport());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        channelViaHeader.setSentBy(this.getHostPort());
        return channelViaHeader;
    }

    public HostPort getViaHostPort() {
        HostPort retval = new HostPort();
        retval.setHost(new Host(this.getViaHost()));
        retval.setPort(this.getViaPort());
        return retval;
    }

    protected void logMessage(SIPMessage sipMessage, InetAddress address, int port, long time) {
        if (!this.getSIPStack().serverLog.needsLogging(16)) {
            return;
        }
        String firstLine = sipMessage.getFirstLine();
        CSeq cseq = (CSeq)sipMessage.getCSeq();
        CallID callid = (CallID)sipMessage.getCallId();
        String cseqBody = cseq.encodeBody();
        String callidBody = callid.encodeBody();
        if (port == -1) {
            port = 5060;
        }
        this.getSIPStack().serverLog.logMessage(sipMessage, this.getHost() + ":" + this.getPort(), address.getHostAddress().toString() + ":" + port, true, time);
    }

    public void logResponse(SIPResponse sipResponse, long receptionTime, String status) {
        int peerport = this.getPeerPort();
        if (peerport == 0 && sipResponse.getContactHeaders() != null) {
            ContactHeader contact = (ContactHeader)sipResponse.getContactHeaders().getFirst();
            peerport = ((AddressImpl)contact.getAddress()).getPort();
        }
        String from = this.getPeerAddress().toString() + ":" + peerport;
        String to = this.getHost() + ":" + this.getPort();
        this.getSIPStack().serverLog.logMessage((SIPMessage)sipResponse, from, to, status, false, receptionTime);
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }
}

