/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import org.jitsi.impl.neomedia.RTPConnectorTCPImpl;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.RTPTransformUDPConnector;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformTCPInputStream;
import org.jitsi.impl.neomedia.transform.TransformTCPOutputStream;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;

public class RTPTransformTCPConnector
extends RTPConnectorTCPImpl {
    private static final Logger logger = Logger.getLogger(RTPTransformUDPConnector.class);
    private TransformEngine engine;

    public RTPTransformTCPConnector(StreamConnector connector) {
        super(connector);
    }

    @Override
    protected TransformTCPInputStream createControlInputStream() throws IOException {
        TransformTCPInputStream controlInputStream = new TransformTCPInputStream(this.getControlSocket());
        controlInputStream.setTransformer(this.getRTCPTransformer());
        return controlInputStream;
    }

    @Override
    protected TransformTCPOutputStream createControlOutputStream() throws IOException {
        TransformTCPOutputStream controlOutputStream = new TransformTCPOutputStream(this.getControlSocket());
        controlOutputStream.setTransformer(this.getRTCPTransformer());
        return controlOutputStream;
    }

    @Override
    protected TransformTCPInputStream createDataInputStream() throws IOException {
        TransformTCPInputStream dataInputStream = new TransformTCPInputStream(this.getDataSocket());
        dataInputStream.setTransformer(this.getRTPTransformer());
        return dataInputStream;
    }

    @Override
    protected TransformTCPOutputStream createDataOutputStream() throws IOException {
        TransformTCPOutputStream dataOutputStream = new TransformTCPOutputStream(this.getDataSocket());
        dataOutputStream.setTransformer(this.getRTPTransformer());
        return dataOutputStream;
    }

    public TransformEngine getEngine() {
        return this.engine;
    }

    private PacketTransformer getRTCPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTCPTransformer();
    }

    private PacketTransformer getRTPTransformer() {
        TransformEngine engine = this.getEngine();
        return engine == null ? null : engine.getRTPTransformer();
    }

    public void setEngine(TransformEngine engine) {
        if (this.engine != engine) {
            TransformTCPOutputStream dataOutputStream;
            TransformTCPInputStream dataInputStream;
            TransformTCPOutputStream controlOutputStream;
            TransformTCPInputStream controlInputStream;
            this.engine = engine;
            try {
                controlInputStream = (TransformTCPInputStream)this.getControlInputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                controlInputStream = null;
            }
            if (controlInputStream != null) {
                controlInputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                controlOutputStream = (TransformTCPOutputStream)this.getControlOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                controlOutputStream = null;
            }
            if (controlOutputStream != null) {
                controlOutputStream.setTransformer(this.getRTCPTransformer());
            }
            try {
                dataInputStream = (TransformTCPInputStream)this.getDataInputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                dataInputStream = null;
            }
            if (dataInputStream != null) {
                dataInputStream.setTransformer(this.getRTPTransformer());
            }
            try {
                dataOutputStream = (TransformTCPOutputStream)this.getDataOutputStream(false);
            }
            catch (IOException ioex) {
                logger.error("The impossible happened", ioex);
                dataOutputStream = null;
            }
            if (dataOutputStream != null) {
                dataOutputStream.setTransformer(this.getRTPTransformer());
            }
        }
    }
}

