/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ChangedAddressAttribute;
import org.ice4j.attribute.ChannelNumberAttribute;
import org.ice4j.attribute.DataAttribute;
import org.ice4j.attribute.DestinationAddressAttribute;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.IceControlledAttribute;
import org.ice4j.attribute.IceControllingAttribute;
import org.ice4j.attribute.LifetimeAttribute;
import org.ice4j.attribute.MagicCookieAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.NonceAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.RealmAttribute;
import org.ice4j.attribute.SourceAddressAttribute;
import org.ice4j.attribute.UnknownAttributesAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.attribute.XorMappedAddressAttribute;
import org.ice4j.attribute.XorPeerAddressAttribute;
import org.ice4j.message.Indication;
import org.ice4j.message.Request;
import org.ice4j.message.Response;

public class MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactory.class.getName());

    public static Request createBindingRequest() {
        Request bindingRequest = new Request();
        try {
            bindingRequest.setMessageType('\u0001');
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return bindingRequest;
    }

    public static Request createBindingRequest(long priority) throws StunException {
        Request bindingRequest = MessageFactory.createBindingRequest();
        PriorityAttribute attribute = AttributeFactory.createPriorityAttribute(priority);
        bindingRequest.addAttribute(attribute);
        return bindingRequest;
    }

    public static Request createBindingRequest(long priority, boolean controlling, long tieBreaker) throws StunException {
        Request bindingRequest = MessageFactory.createBindingRequest();
        PriorityAttribute attribute = AttributeFactory.createPriorityAttribute(priority);
        bindingRequest.addAttribute(attribute);
        if (controlling) {
            IceControllingAttribute iceControllingAttribute = AttributeFactory.createIceControllingAttribute(tieBreaker);
            bindingRequest.addAttribute(iceControllingAttribute);
        } else {
            IceControlledAttribute iceControlledAttribute = AttributeFactory.createIceControlledAttribute(tieBreaker);
            bindingRequest.addAttribute(iceControlledAttribute);
        }
        return bindingRequest;
    }

    public static Response create3489BindingResponse(TransportAddress mappedAddress, TransportAddress sourceAddress, TransportAddress changedAddress) throws IllegalArgumentException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        MappedAddressAttribute mappedAddressAttribute = AttributeFactory.createMappedAddressAttribute(mappedAddress);
        SourceAddressAttribute sourceAddressAttribute = null;
        if (sourceAddress != null) {
            sourceAddressAttribute = AttributeFactory.createSourceAddressAttribute(sourceAddress);
        }
        ChangedAddressAttribute changedAddressAttribute = null;
        if (changedAddress != null) {
            changedAddressAttribute = AttributeFactory.createChangedAddressAttribute(changedAddress);
        }
        bindingResponse.addAttribute(mappedAddressAttribute);
        if (sourceAddressAttribute != null) {
            bindingResponse.addAttribute(sourceAddressAttribute);
        }
        if (changedAddressAttribute != null) {
            bindingResponse.addAttribute(changedAddressAttribute);
        }
        return bindingResponse;
    }

    public static Response createBindingResponse(Request request, TransportAddress mappedAddress) throws IllegalArgumentException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        XorMappedAddressAttribute xorMappedAddressAttribute = AttributeFactory.createXorMappedAddressAttribute(mappedAddress, request.getTransactionID());
        bindingResponse.addAttribute(xorMappedAddressAttribute);
        return bindingResponse;
    }

    public static Response createBindingErrorResponse(char errorCode, String reasonPhrase, char[] unknownAttributes) throws IllegalArgumentException {
        Response bindingErrorResponse = new Response();
        bindingErrorResponse.setMessageType('\u0111');
        UnknownAttributesAttribute unknownAttributesAttribute = null;
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        bindingErrorResponse.addAttribute(errorCodeAttribute);
        if (unknownAttributes != null) {
            unknownAttributesAttribute = AttributeFactory.createUnknownAttributesAttribute();
            for (int i = 0; i < unknownAttributes.length; ++i) {
                unknownAttributesAttribute.addAttributeID(unknownAttributes[i]);
            }
            bindingErrorResponse.addAttribute(unknownAttributesAttribute);
        }
        return bindingErrorResponse;
    }

    public static Response createBindingErrorResponseUnknownAttributes(char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', null, unknownAttributes);
    }

    public static Response createBindingErrorResponseUnknownAttributes(String reasonPhrase, char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', reasonPhrase, unknownAttributes);
    }

    public static Response createBindingErrorResponse(char errorCode, String reasonPhrase) {
        return MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase, null);
    }

    public static Response createBindingErrorResponse(char errorCode) {
        return MessageFactory.createBindingErrorResponse(errorCode, null, null);
    }

    public static Indication createBindingIndication() {
        Indication bindingIndication = new Indication();
        bindingIndication.setMessageType('\u0011');
        return bindingIndication;
    }

    public static Request createAllocateRequest() {
        Request allocateRequest = new Request();
        try {
            allocateRequest.setMessageType('\u0003');
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return allocateRequest;
    }

    public static Request createAllocateRequest(byte protocol, boolean rFlag) {
        Request allocateRequest = new Request();
        try {
            allocateRequest.setMessageType('\u0003');
            if (protocol != 6 && protocol != 17) {
                throw new StunException("Protocol not valid!");
            }
            allocateRequest.addAttribute(AttributeFactory.createRequestedTransportAttribute(protocol));
            if (rFlag) {
                allocateRequest.addAttribute(AttributeFactory.createEvenPortAttribute(rFlag));
            }
        }
        catch (StunException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return allocateRequest;
    }

    public static Request createGoogleAllocateRequest(String username) {
        Request allocateRequest = new Request();
        UsernameAttribute usernameAttr = AttributeFactory.createUsernameAttribute(username);
        MagicCookieAttribute magicCookieAttr = AttributeFactory.createMagicCookieAttribute();
        allocateRequest.setMessageType('\u0003');
        allocateRequest.addAttribute(magicCookieAttr);
        allocateRequest.addAttribute(usernameAttr);
        return allocateRequest;
    }

    public static void addLongTermCredentialAttributes(Request request, byte[] username, byte[] realm, byte[] nonce) throws StunException {
        MessageIntegrityAttribute messageIntegrityAttribute;
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(username);
        RealmAttribute realmAttribute = AttributeFactory.createRealmAttribute(realm);
        NonceAttribute nonceAttribute = AttributeFactory.createNonceAttribute(nonce);
        request.addAttribute(usernameAttribute);
        request.addAttribute(realmAttribute);
        request.addAttribute(nonceAttribute);
        try {
            messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(username, "UTF-8"));
        }
        catch (UnsupportedEncodingException ueex) {
            throw new StunException("username", ueex);
        }
        request.addAttribute(messageIntegrityAttribute);
    }

    public static Request createRefreshRequest() {
        Request refreshRequest = new Request();
        try {
            refreshRequest.setMessageType('\u0004');
        }
        catch (IllegalArgumentException iaex) {
            logger.log(Level.FINE, "Failed to set message type.", iaex);
        }
        return refreshRequest;
    }

    public static Request createRefreshRequest(int lifetime) {
        Request refreshRequest = new Request();
        try {
            refreshRequest.setMessageType('\u0004');
            LifetimeAttribute lifetimeReq = AttributeFactory.createLifetimeAttribute(lifetime);
            refreshRequest.addAttribute(lifetimeReq);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return refreshRequest;
    }

    public static Request createChannelBindRequest(char channelNumber, TransportAddress peerAddress, byte[] tranID) {
        Request channelBindRequest = new Request();
        try {
            channelBindRequest.setMessageType('\t');
            ChannelNumberAttribute channelNumberAttribute = AttributeFactory.createChannelNumberAttribute(channelNumber);
            channelBindRequest.addAttribute(channelNumberAttribute);
            XorPeerAddressAttribute peerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, tranID);
            channelBindRequest.addAttribute(peerAddressAttribute);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return channelBindRequest;
    }

    public static Request createCreatePermissionRequest(TransportAddress peerAddress, byte[] transactionID) {
        Request createPermissionRequest = new Request();
        try {
            createPermissionRequest.setMessageType('\b');
        }
        catch (IllegalArgumentException iaex) {
            logger.log(Level.FINE, "Failed to set message type.", iaex);
        }
        createPermissionRequest.addAttribute(AttributeFactory.createXorPeerAddressAttribute(peerAddress, transactionID));
        return createPermissionRequest;
    }

    public static Indication createSendIndication(TransportAddress peerAddress, byte[] data, byte[] tranID) {
        Indication sendIndication = new Indication();
        try {
            sendIndication.setMessageType('\u0016');
            XorPeerAddressAttribute peerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, tranID);
            sendIndication.addAttribute(peerAddressAttribute);
            if (data != null && data.length > 0) {
                DataAttribute dataAttribute = AttributeFactory.createDataAttribute(data);
                sendIndication.addAttribute(dataAttribute);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return sendIndication;
    }

    public static Request createSendRequest(String username, TransportAddress peerAddress, byte[] data) {
        Request sendRequest = new Request();
        try {
            sendRequest.setMessageType('\u0004');
            sendRequest.addAttribute(AttributeFactory.createMagicCookieAttribute());
            sendRequest.addAttribute(AttributeFactory.createUsernameAttribute(username));
            DestinationAddressAttribute peerAddressAttribute = AttributeFactory.createDestinationAddressAttribute(peerAddress);
            sendRequest.addAttribute(peerAddressAttribute);
            if (data != null && data.length > 0) {
                DataAttribute dataAttribute = AttributeFactory.createDataAttributeWithoutPadding(data);
                sendRequest.addAttribute(dataAttribute);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return sendRequest;
    }

    public static Request createSharedSecretRequest() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }

    public static Response createSharedSecretResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }

    public static Response createSharedSecretErrorResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }
}

