/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerMediaHandlerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.IceUdpTransportManager;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingClientJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.QualityControlWrapper;
import net.java.sip.communicator.impl.protocol.jabber.RawUdpTransportManager;
import net.java.sip.communicator.impl.protocol.jabber.ScServiceDiscoveryManager;
import net.java.sip.communicator.impl.protocol.jabber.TransportInfoSender;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.InputEvtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.jinglesdp.JingleUtils;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.service.protocol.media.SrtpControls;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class CallPeerMediaHandlerJabberImpl
extends AbstractCallPeerMediaHandlerJabberGTalkImpl<CallPeerJabberImpl> {
    private static final Logger logger = Logger.getLogger(CallPeerMediaHandlerJabberImpl.class);
    private final Map<String, ContentPacketExtension> localContentMap = new LinkedHashMap<String, ContentPacketExtension>();
    private final QualityControlWrapper qualityControls;
    private final Map<String, ContentPacketExtension> remoteContentMap = new LinkedHashMap<String, ContentPacketExtension>();
    private boolean remotelyOnHold = false;
    private boolean supportQualityControls = false;
    private TransportManagerJabberImpl transportManager;
    private final Object transportManagerSyncRoot = new Object();
    private String[] supportedTransports = null;
    private final Object supportedTransportsSyncRoot = new Object();

    private static boolean isFeatureSupported(ScServiceDiscoveryManager discoveryManager, DiscoverInfo discoverInfo, String feature) {
        return discoveryManager.includesFeature(feature) && (discoverInfo == null || discoverInfo.containsFeature(feature));
    }

    public CallPeerMediaHandlerJabberImpl(CallPeerJabberImpl peer) {
        super(peer);
        this.qualityControls = new QualityControlWrapper(peer);
    }

    private MediaDirection calculatePostHoldDirection(MediaStream stream) {
        MediaDirection streamDirection = stream.getDirection();
        if (streamDirection.allowsSending()) {
            return streamDirection;
        }
        ContentPacketExtension content = this.remoteContentMap.get(stream.getName());
        MediaDirection postHoldDir = JingleUtils.getDirection(content, !((CallPeerJabberImpl)this.getPeer()).isInitiator());
        MediaDevice device = stream.getDevice();
        postHoldDir = postHoldDir.and(this.getDirectionUserPreference(device.getMediaType()));
        if (this.isLocallyOnHold()) {
            postHoldDir = postHoldDir.and(MediaDirection.SENDONLY);
        }
        postHoldDir = postHoldDir.and(device.getDirection());
        return postHoldDir;
    }

    public synchronized void close() {
        super.close();
        OperationSetDesktopSharingClientJabberImpl client = (OperationSetDesktopSharingClientJabberImpl)((ProtocolProviderServiceJabberImpl)((CallPeerJabberImpl)this.getPeer()).getProtocolProvider()).getOperationSet(OperationSetDesktopSharingClient.class);
        if (client != null) {
            client.fireRemoteControlRevoked((CallPeer)this.getPeer());
        }
    }

    private ContentPacketExtension createContent(MediaDevice dev) throws OperationFailedException {
        CallJabberImpl call;
        MediaType mediaType = dev.getMediaType();
        MediaDirection direction = dev.getDirection();
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        if (!MediaType.VIDEO.equals((Object)mediaType) || !this.isRTPTranslationEnabled(mediaType)) {
            direction = direction.and(this.getDirectionUserPreference(mediaType));
        }
        if ((call = (CallJabberImpl)peer.getCall()).isConferenceFocus()) {
            for (CallPeerJabberImpl anotherPeer : call.getCallPeerList()) {
                if (anotherPeer == peer || !anotherPeer.getDirection(mediaType).allowsReceiving()) continue;
                direction = direction.or(MediaDirection.SENDONLY);
                break;
            }
        }
        if (this.isLocallyOnHold()) {
            direction = direction.and(MediaDirection.SENDONLY);
        }
        QualityPreset sendQualityPreset = null;
        QualityPreset receiveQualityPreset = null;
        if (this.qualityControls != null) {
            sendQualityPreset = this.qualityControls.getRemoteReceivePreset();
            receiveQualityPreset = this.qualityControls.getRemoteSendMaxPreset();
        }
        if (direction != MediaDirection.INACTIVE) {
            ContentPacketExtension content = this.createContentForOffer(this.getLocallySupportedFormats(dev, sendQualityPreset, receiveQualityPreset), direction, dev.getSupportedExtensions());
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
            this.setDtlsEncryptionOnContent(mediaType, content, null);
            if (!call.getConference().isJitsiVideobridge()) {
                this.setSDesEncryptionOnDescription(mediaType, description, null);
                this.setZrtpEncryptionOnDescription(mediaType, description, null);
            }
            return content;
        }
        return null;
    }

    public ContentPacketExtension createContentForMedia(MediaType mediaType) throws OperationFailedException {
        MediaDevice dev = this.getDefaultDevice(mediaType);
        if (this.isDeviceActive(dev)) {
            return this.createContent(dev);
        }
        return null;
    }

    private ContentPacketExtension createContentForOffer(List<MediaFormat> supportedFormats, MediaDirection direction, List<RTPExtension> supportedExtensions) {
        ContentPacketExtension content = JingleUtils.createDescription(ContentPacketExtension.CreatorEnum.initiator, supportedFormats.get(0).getMediaType().toString(), JingleUtils.getSenders(direction, !((CallPeerJabberImpl)this.getPeer()).isInitiator()), supportedFormats, supportedExtensions, this.getDynamicPayloadTypes(), this.getRtpExtensionsRegistry());
        this.localContentMap.put(content.getName(), content);
        return content;
    }

    public List<ContentPacketExtension> createContentList() throws OperationFailedException {
        ArrayList<ContentPacketExtension> mediaDescs = new ArrayList<ContentPacketExtension>();
        boolean jitsiVideobridge = ((CallJabberImpl)((CallPeerJabberImpl)this.getPeer()).getCall()).getConference().isJitsiVideobridge();
        for (MediaType mediaType : MediaType.values()) {
            MediaDevice dev = this.getDefaultDevice(mediaType);
            if (!this.isDeviceActive(dev)) continue;
            MediaDirection direction = dev.getDirection();
            if (!MediaType.VIDEO.equals((Object)mediaType) || !this.isRTPTranslationEnabled(mediaType)) {
                direction = direction.and(this.getDirectionUserPreference(mediaType));
            }
            if (this.isLocallyOnHold()) {
                direction = direction.and(MediaDirection.SENDONLY);
            }
            if (MediaDirection.RECVONLY.equals((Object)direction)) {
                direction = MediaDirection.INACTIVE;
            }
            if (direction == MediaDirection.INACTIVE) continue;
            ContentPacketExtension content = this.createContentForOffer(this.getLocallySupportedFormats(dev), direction, dev.getSupportedExtensions());
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
            this.setDtlsEncryptionOnContent(mediaType, content, null);
            if (!jitsiVideobridge) {
                this.setSDesEncryptionOnDescription(mediaType, description, null);
                this.setZrtpEncryptionOnDescription(mediaType, description, null);
            }
            if (description.getMedia().equals(MediaType.VIDEO.toString()) && this.getLocalInputEvtAware()) {
                content.addChildExtension(new InputEvtPacketExtension());
            }
            mediaDescs.add(content);
        }
        if (mediaDescs.isEmpty()) {
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("We couldn't find any active Audio/Video devices and couldn't create a call", 1, null, logger);
        }
        return this.harvestCandidates(null, mediaDescs, null);
    }

    public List<ContentPacketExtension> createContentList(MediaType mediaType) throws OperationFailedException {
        ContentPacketExtension content;
        MediaDevice dev = this.getDefaultDevice(mediaType);
        ArrayList<ContentPacketExtension> mediaDescs = new ArrayList<ContentPacketExtension>();
        if (this.isDeviceActive(dev) && (content = this.createContent(dev)) != null) {
            mediaDescs.add(content);
        }
        if (mediaDescs.isEmpty()) {
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("We couldn't find any active Audio/Video devices and couldn't create a call", 1, null, logger);
        }
        return this.harvestCandidates(null, mediaDescs, null);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        super.firePropertyChange(property, oldValue, newValue);
    }

    public Iterable<ContentPacketExtension> generateSessionAccept() throws OperationFailedException {
        TransportManagerJabberImpl transportManager = this.getTransportManager();
        List<ContentPacketExtension> sessAccept = transportManager.wrapupCandidateHarvest();
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        HashMap<ContentPacketExtension, RtpDescriptionPacketExtension> contents = new HashMap<ContentPacketExtension, RtpDescriptionPacketExtension>();
        for (ContentPacketExtension ourContent : sessAccept) {
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(ourContent);
            contents.put(ourContent, description);
        }
        boolean masterStreamSet = false;
        for (Map.Entry en : contents.entrySet()) {
            PayloadTypePacketExtension payload;
            MediaFormat remoteFormat;
            ContentPacketExtension ourContent = (ContentPacketExtension)en.getKey();
            RtpDescriptionPacketExtension description = (RtpDescriptionPacketExtension)en.getValue();
            MediaType type = MediaType.parseString((String)description.getMedia());
            StreamConnector connector = transportManager.getStreamConnector(type);
            MediaDevice dev = this.getDefaultDevice(type);
            if (!this.isDeviceActive(dev)) continue;
            MediaStreamTarget target = transportManager.getStreamTarget(type);
            MediaDirection direction = JingleUtils.getDirection(ourContent, !peer.isInitiator());
            if (MediaType.VIDEO.equals((Object)type) && (this.isLocalVideoTransmissionEnabled() || this.isRTPTranslationEnabled(type)) && dev.getDirection().allowsSending()) {
                direction = MediaDirection.SENDRECV;
                ourContent.setSenders(ContentPacketExtension.SendersEnum.both);
            }
            String contentName = ourContent.getName();
            ContentPacketExtension theirContent = this.remoteContentMap.get(contentName);
            RtpDescriptionPacketExtension theirDescription = JingleUtils.getRtpDescription(theirContent);
            MediaFormat format = null;
            List localFormats = this.getLocallySupportedFormats(dev);
            Iterator<PayloadTypePacketExtension> i$ = theirDescription.getPayloadTypes().iterator();
            while (i$.hasNext() && ((remoteFormat = JingleUtils.payloadTypeToMediaFormat(payload = i$.next(), this.getDynamicPayloadTypes())) == null || (format = this.findMediaFormat(localFormats, remoteFormat)) == null)) {
            }
            if (format == null) {
                ProtocolProviderServiceJabberImpl.throwOperationFailedException("No matching codec.", 11, null, logger);
            }
            List<RTPExtension> rtpExtensions = JingleUtils.extractRTPExtensions(description, this.getRtpExtensionsRegistry());
            Map adv = format.getAdvancedAttributes();
            if (adv != null) {
                for (Map.Entry f : adv.entrySet()) {
                    if (!((String)f.getKey()).equals("imageattr")) continue;
                    this.supportQualityControls = true;
                }
            }
            boolean masterStream = false;
            if (!masterStreamSet) {
                if (contents.size() > 1) {
                    if (type.equals((Object)MediaType.AUDIO)) {
                        masterStream = true;
                        masterStreamSet = true;
                    }
                } else {
                    masterStream = true;
                    masterStreamSet = true;
                }
            }
            this.initStream(contentName, connector, dev, format, target, direction, rtpExtensions, masterStream);
        }
        return sessAccept;
    }

    public ContentPacketExtension getLocalContent(String contentType) {
        for (String key : this.localContentMap.keySet()) {
            ContentPacketExtension content = this.localContentMap.get(key);
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
            if (!description.getMedia().equals(contentType)) continue;
            return content;
        }
        return null;
    }

    public Iterable<ContentPacketExtension> getLocalContentList() {
        return this.localContentMap.values();
    }

    public QualityControl getQualityControl() {
        if (this.supportQualityControls) {
            return this.qualityControls;
        }
        return null;
    }

    public ContentPacketExtension getRemoteContent(String contentType) {
        for (String key : this.remoteContentMap.keySet()) {
            ContentPacketExtension content = this.remoteContentMap.get(key);
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
            if (!description.getMedia().equals(contentType)) continue;
            return content;
        }
        return null;
    }

    public long getRemoteSSRC(MediaType mediaType) {
        int[] ssrcs = this.getRemoteSSRCs(mediaType);
        if (ssrcs.length != 0) {
            return 0xFFFFFFFFL & (long)ssrcs[ssrcs.length - 1];
        }
        return ((CallPeerJabberImpl)this.getPeer()).isJitsiVideobridge() ? -1L : super.getRemoteSSRC(mediaType);
    }

    private int[] getRemoteSSRCs(MediaType mediaType) {
        int[] nArray;
        ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType);
        if (channel != null) {
            return channel.getSSRCs();
        }
        long ssrc = super.getRemoteSSRC(mediaType);
        if (ssrc == -1L) {
            nArray = ColibriConferenceIQ.NO_SSRCS;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = (int)ssrc;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized TransportManagerJabberImpl getTransportManager() {
        if (this.transportManager == null) {
            CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
            if (peer.isInitiator()) {
                Object object = this.transportManagerSyncRoot;
                synchronized (object) {
                    try {
                        this.transportManagerSyncRoot.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (this.transportManager == null) {
                    throw new IllegalStateException("The initiator is expected to specify the transport in their offer.");
                }
                return this.transportManager;
            }
            ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)peer.getProtocolProvider();
            ScServiceDiscoveryManager discoveryManager = protocolProvider.getDiscoveryManager();
            DiscoverInfo peerDiscoverInfo = peer.getDiscoveryInfo();
            Object object = this.supportedTransportsSyncRoot;
            synchronized (object) {
                if (this.supportedTransports != null && this.supportedTransports.length > 0) {
                    for (int i = 0; i < this.supportedTransports.length; ++i) {
                        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(this.supportedTransports[i])) {
                            this.transportManager = new IceUdpTransportManager(peer);
                            break;
                        }
                        if (!"urn:xmpp:jingle:transports:raw-udp:1".equals(this.supportedTransports[i])) continue;
                        this.transportManager = new RawUdpTransportManager(peer);
                        break;
                    }
                    if (this.transportManager == null) {
                        logger.warn((Object)"Could not find a supported TransportManager in supportedTransports. Will try to select one based on disco#info.");
                    }
                }
            }
            if (this.transportManager == null) {
                String jitsiVideobridge;
                CallJabberImpl call;
                String[] transports = new String[]{"urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:transports:raw-udp:1"};
                if (peer.isJitsiVideobridge() && (call = (CallJabberImpl)peer.getCall()) != null && (jitsiVideobridge = ((CallJabberImpl)peer.getCall()).getJitsiVideobridge()) != null && !protocolProvider.isFeatureSupported(jitsiVideobridge, "urn:xmpp:jingle:transports:ice-udp:1")) {
                    for (int i = transports.length - 1; i >= 0; --i) {
                        if (!"urn:xmpp:jingle:transports:ice-udp:1".equals(transports[i])) continue;
                        transports[i] = null;
                    }
                }
                for (String transport : transports) {
                    if (transport == null || !CallPeerMediaHandlerJabberImpl.isFeatureSupported(discoveryManager, peerDiscoverInfo, transport)) continue;
                    if ("urn:xmpp:jingle:transports:ice-udp:1".equals(transport)) {
                        this.transportManager = new IceUdpTransportManager(peer);
                    } else if ("urn:xmpp:jingle:transports:raw-udp:1".equals(transport)) {
                        this.transportManager = new RawUdpTransportManager(peer);
                    }
                    if (this.transportManager != null) break;
                }
                if (this.transportManager == null && logger.isDebugEnabled()) {
                    logger.debug((Object)("No known Jingle transport supported by Jabber call peer " + (Object)((Object)peer)));
                }
            }
        }
        return this.transportManager;
    }

    protected synchronized TransportManagerJabberImpl queryTransportManager() {
        return this.transportManager;
    }

    public List<Component> getVisualComponents() {
        MediaAwareCallConference conference;
        CallJabberImpl call = (CallJabberImpl)((CallPeerJabberImpl)this.getPeer()).getCall();
        if (call != null && (conference = call.getConference()) != null && conference.isJitsiVideobridge()) {
            MediaStream stream = this.getStream(MediaType.VIDEO);
            if (stream == null) {
                return Collections.emptyList();
            }
            int[] remoteSSRCs = this.getRemoteSSRCs(MediaType.VIDEO);
            if (remoteSSRCs.length == 0) {
                return Collections.emptyList();
            }
            VideoMediaStream videoStream = (VideoMediaStream)stream;
            LinkedList<Component> visualComponents = new LinkedList<Component>();
            for (int i = 0; i < remoteSSRCs.length; ++i) {
                int remoteSSRC = remoteSSRCs[i];
                Component visualComponent = videoStream.getVisualComponent(0xFFFFFFFFL & (long)remoteSSRC);
                if (visualComponent == null) continue;
                visualComponents.add(visualComponent);
            }
            return visualComponents;
        }
        return super.getVisualComponents();
    }

    private List<ContentPacketExtension> harvestCandidates(List<ContentPacketExtension> remote, List<ContentPacketExtension> local, TransportInfoSender transportInfoSender) throws OperationFailedException {
        long startCandidateHarvestTime = System.currentTimeMillis();
        TransportManagerJabberImpl transportManager = this.getTransportManager();
        if (remote == null) {
            if (transportInfoSender != null) {
                throw new IllegalArgumentException("transportInfoSender");
            }
            transportManager.startCandidateHarvest(local, transportInfoSender);
        } else {
            transportManager.startCandidateHarvest(remote, local, transportInfoSender);
        }
        long stopCandidateHarvestTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            long candidateHarvestTime = stopCandidateHarvestTime - startCandidateHarvestTime;
            logger.info((Object)("End candidate harvest within " + candidateHarvestTime + " ms"));
        }
        this.setDtlsEncryptionOnTransports(remote, local);
        if (transportManager.startConnectivityEstablishmentWithJitsiVideobridge) {
            LinkedHashMap<String, IceUdpTransportPacketExtension> map = new LinkedHashMap<String, IceUdpTransportPacketExtension>();
            for (MediaType mediaType : MediaType.values()) {
                IceUdpTransportPacketExtension transport;
                ColibriConferenceIQ.Channel channel = transportManager.getColibriChannel(mediaType, true);
                if (channel == null || (transport = channel.getTransport()) == null) continue;
                map.put(mediaType.toString(), transport);
            }
            if (!map.isEmpty()) {
                transportManager.startConnectivityEstablishmentWithJitsiVideobridge = false;
                transportManager.startConnectivityEstablishment(map);
            }
        }
        return transportManager.wrapupCandidateHarvest();
    }

    protected MediaStream initStream(String streamName, StreamConnector connector, MediaDevice device, MediaFormat format, MediaStreamTarget target, MediaDirection direction, List<RTPExtension> rtpExtensions, boolean masterStream) throws OperationFailedException {
        MediaStream stream = super.initStream(connector, device, format, target, direction, rtpExtensions, masterStream);
        if (stream != null) {
            stream.setName(streamName);
        }
        return stream;
    }

    protected void mediaHandlerPropertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (("AUDIO_REMOTE_SSRC".equals(propertyName) || "VIDEO_REMOTE_SSRC".equals(propertyName)) && ((CallPeerJabberImpl)this.getPeer()).isJitsiVideobridge()) {
            return;
        }
        super.mediaHandlerPropertyChange(ev);
    }

    public void processAnswer(List<ContentPacketExtension> answer) throws OperationFailedException, IllegalArgumentException {
        this.processTransportInfo(answer);
        boolean masterStreamSet = false;
        for (ContentPacketExtension content : answer) {
            this.remoteContentMap.put(content.getName(), content);
            boolean masterStream = false;
            if (!masterStreamSet) {
                if (answer.size() > 1) {
                    RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
                    if (MediaType.AUDIO.toString().equals(description.getMedia())) {
                        masterStream = true;
                        masterStreamSet = true;
                    }
                } else {
                    masterStream = true;
                    masterStreamSet = true;
                }
            }
            this.processContent(content, false, masterStream);
        }
    }

    void processColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) {
        TransportManagerJabberImpl transportManager = this.transportManager;
        if (transportManager != null) {
            long oldAudioRemoteSSRC = this.getRemoteSSRC(MediaType.AUDIO);
            long oldVideoRemoteSSRC = this.getRemoteSSRC(MediaType.VIDEO);
            for (MediaType mediaType : MediaType.values()) {
                ColibriConferenceIQ.Channel src;
                ColibriConferenceIQ.Content content;
                ColibriConferenceIQ.Channel dst = transportManager.getColibriChannel(mediaType, false);
                if (dst == null || (content = conferenceIQ.getContent(mediaType.toString())) == null || (src = content.getChannel(dst.getID())) == null) continue;
                int[] ssrcs = src.getSSRCs();
                int[] dstSSRCs = dst.getSSRCs();
                if (Arrays.equals(dstSSRCs, ssrcs)) continue;
                dst.setSSRCs(ssrcs);
            }
            long newAudioRemoteSSRC = this.getRemoteSSRC(MediaType.AUDIO);
            long newVideoRemoteSSRC = this.getRemoteSSRC(MediaType.VIDEO);
            if (oldAudioRemoteSSRC != newAudioRemoteSSRC) {
                this.firePropertyChange("AUDIO_REMOTE_SSRC", oldAudioRemoteSSRC, newAudioRemoteSSRC);
            }
            if (oldVideoRemoteSSRC != newVideoRemoteSSRC) {
                this.firePropertyChange("VIDEO_REMOTE_SSRC", oldVideoRemoteSSRC, newVideoRemoteSSRC);
            }
        }
    }

    private void processContent(ContentPacketExtension content, boolean modify, boolean masterStream) throws OperationFailedException, IllegalArgumentException {
        CallJabberImpl call;
        MediaAwareCallConference conference;
        RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
        MediaType mediaType = MediaType.parseString((String)description.getMedia());
        TransportManagerJabberImpl transportManager = this.getTransportManager();
        MediaStreamTarget target = transportManager.getStreamTarget(mediaType);
        if (target == null) {
            target = JingleUtils.extractDefaultTarget(content);
        }
        if (target == null || target.getDataAddress().getPort() == 0) {
            this.closeStream(mediaType);
            return;
        }
        List<MediaFormat> supportedFormats = JingleUtils.extractFormats(description, this.getDynamicPayloadTypes());
        MediaDevice dev = this.getDefaultDevice(mediaType);
        if (!this.isDeviceActive(dev)) {
            this.closeStream(mediaType);
            return;
        }
        MediaDirection devDirection = dev == null ? MediaDirection.INACTIVE : dev.getDirection();
        devDirection = devDirection.and(this.getDirectionUserPreference(mediaType));
        if (supportedFormats.isEmpty()) {
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("Remote party sent an invalid Jingle answer.", 11, null, logger);
        }
        MediaAwareCallConference mediaAwareCallConference = conference = (call = (CallJabberImpl)((CallPeerJabberImpl)this.getPeer()).getCall()) == null ? null : call.getConference();
        if (conference == null || !conference.isJitsiVideobridge()) {
            this.addZrtpAdvertisedEncryptions(true, description, mediaType);
            this.addSDesAdvertisedEncryptions(true, description, mediaType);
        }
        this.addDtlsAdvertisedEncryptions(true, content, mediaType);
        StreamConnector connector = transportManager.getStreamConnector(mediaType);
        MediaDirection remoteDirection = JingleUtils.getDirection(content, ((CallPeerJabberImpl)this.getPeer()).isInitiator());
        if (conference != null && conference.isConferenceFocus()) {
            for (CallPeerJabberImpl peer : call.getCallPeerList()) {
                ContentPacketExtension.SendersEnum senders = peer.getSenders(mediaType);
                boolean initiator = peer.isInitiator();
                if (senders != null && ContentPacketExtension.SendersEnum.both != senders && (!initiator || ContentPacketExtension.SendersEnum.initiator != senders) && (initiator || ContentPacketExtension.SendersEnum.responder != senders)) continue;
                remoteDirection = remoteDirection.or(MediaDirection.SENDONLY);
            }
        }
        MediaDirection direction = devDirection.getDirectionForAnswer(remoteDirection);
        List<RTPExtension> remoteRTPExtensions = JingleUtils.extractRTPExtensions(description, this.getRtpExtensionsRegistry());
        List supportedExtensions = this.getExtensionsForType(mediaType);
        List rtpExtensions = this.intersectRTPExtensions(remoteRTPExtensions, supportedExtensions);
        Map adv = supportedFormats.get(0).getAdvancedAttributes();
        if (adv != null) {
            for (Map.Entry f : adv.entrySet()) {
                if (!((String)f.getKey()).equals("imageattr")) continue;
                this.supportQualityControls = true;
            }
        }
        if (mediaType.equals((Object)MediaType.VIDEO) && modify) {
            List<MediaFormat> fmts;
            MediaStream stream = this.getStream(MediaType.VIDEO);
            if (stream != null && dev != null && (fmts = supportedFormats).size() > 0) {
                MediaFormat fmt = fmts.get(0);
                ((VideoMediaStream)stream).updateQualityControl(fmt.getAdvancedAttributes());
            }
            if (this.qualityControls != null) {
                QualityPreset receiveQualityPreset = this.qualityControls.getRemoteReceivePreset();
                QualityPreset sendQualityPreset = this.qualityControls.getRemoteSendMaxPreset();
                supportedFormats = dev == null ? null : this.intersectFormats(supportedFormats, this.getLocallySupportedFormats(dev, sendQualityPreset, receiveQualityPreset));
            }
        }
        this.initStream(content.getName(), connector, dev, supportedFormats.get(0), target, direction, rtpExtensions, masterStream);
    }

    public void processOffer(List<ContentPacketExtension> offer) throws OperationFailedException, IllegalArgumentException {
        ArrayList<ContentPacketExtension> answer = new ArrayList<ContentPacketExtension>(offer.size());
        boolean atLeastOneValidDescription = false;
        for (ContentPacketExtension content : offer) {
            this.remoteContentMap.put(content.getName(), content);
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(content);
            MediaType mediaType = MediaType.parseString((String)description.getMedia());
            List<MediaFormat> remoteFormats = JingleUtils.extractFormats(description, this.getDynamicPayloadTypes());
            MediaDevice dev = this.getDefaultDevice(mediaType);
            MediaDirection devDirection = dev == null ? MediaDirection.INACTIVE : dev.getDirection();
            devDirection = devDirection.and(this.getDirectionUserPreference(mediaType));
            MediaDirection remoteDirection = JingleUtils.getDirection(content, ((CallPeerJabberImpl)this.getPeer()).isInitiator());
            MediaDirection direction = devDirection.getDirectionForAnswer(remoteDirection);
            List mutuallySupportedFormats = this.intersectFormats(remoteFormats, this.getLocallySupportedFormats(dev));
            List<RTPExtension> offeredRTPExtensions = JingleUtils.extractRTPExtensions(description, this.getRtpExtensionsRegistry());
            List supportedExtensions = this.getExtensionsForType(mediaType);
            List rtpExtensions = this.intersectRTPExtensions(offeredRTPExtensions, supportedExtensions);
            IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            MediaStreamTarget target = null;
            try {
                target = JingleUtils.extractDefaultTarget(content);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Fail to extract default target", (Throwable)e);
            }
            int targetDataPort = target == null && transport != null ? -1 : (target != null ? target.getDataAddress().getPort() : 0);
            this.setTransportManager(transport.getNamespace());
            if (mutuallySupportedFormats.isEmpty() || devDirection == MediaDirection.INACTIVE || targetDataPort == 0) {
                this.closeStream(mediaType);
                continue;
            }
            ContentPacketExtension.SendersEnum senders = JingleUtils.getSenders(direction, !((CallPeerJabberImpl)this.getPeer()).isInitiator());
            ContentPacketExtension ourContent = JingleUtils.createDescription(content.getCreator(), content.getName(), senders, mutuallySupportedFormats, rtpExtensions, this.getDynamicPayloadTypes(), this.getRtpExtensionsRegistry());
            this.setAndAddPreferredEncryptionProtocol(mediaType, ourContent, content);
            if (content.getChildExtensionsOfType(InputEvtPacketExtension.class) != null) {
                ourContent.addChildExtension(new InputEvtPacketExtension());
            }
            answer.add(ourContent);
            this.localContentMap.put(content.getName(), ourContent);
            atLeastOneValidDescription = true;
        }
        if (!atLeastOneValidDescription) {
            ProtocolProviderServiceJabberImpl.throwOperationFailedException("Offer contained no media formats or no valid media descriptions.", 11, null, logger);
        }
        this.harvestCandidates(offer, answer, new TransportInfoSender(){

            @Override
            public void sendTransportInfo(Iterable<ContentPacketExtension> contents) {
                ((CallPeerJabberImpl)CallPeerMediaHandlerJabberImpl.this.getPeer()).sendTransportInfo(contents);
            }
        });
        this.getTransportManager().startConnectivityEstablishment(offer);
    }

    public void processTransportInfo(Iterable<ContentPacketExtension> contents) throws OperationFailedException {
        if (this.getTransportManager().startConnectivityEstablishment(contents)) {
            // empty if block
        }
    }

    public void reinitAllContents() throws OperationFailedException, IllegalArgumentException {
        boolean masterStreamSet = false;
        for (String key : this.remoteContentMap.keySet()) {
            ContentPacketExtension ext = this.remoteContentMap.get(key);
            boolean masterStream = false;
            if (!masterStreamSet) {
                RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(ext);
                MediaType mediaType = MediaType.parseString((String)description.getMedia());
                if (this.remoteContentMap.size() > 1) {
                    if (mediaType.equals((Object)MediaType.AUDIO)) {
                        masterStream = true;
                        masterStreamSet = true;
                    }
                } else {
                    masterStream = true;
                    masterStreamSet = true;
                }
            }
            if (ext == null) continue;
            this.processContent(ext, false, masterStream);
        }
    }

    public void reinitContent(String name, ContentPacketExtension content, boolean modify) throws OperationFailedException, IllegalArgumentException {
        ContentPacketExtension ext = this.remoteContentMap.get(name);
        if (ext != null) {
            if (modify) {
                this.processContent(content, modify, false);
                this.remoteContentMap.put(name, content);
            } else {
                ext.setSenders(content.getSenders());
                this.processContent(ext, modify, false);
                this.remoteContentMap.put(name, ext);
            }
        }
    }

    private void removeContent(Map<String, ContentPacketExtension> contentMap, String name) {
        RtpDescriptionPacketExtension description;
        String media;
        ContentPacketExtension content = contentMap.remove(name);
        if (content != null && (media = (description = JingleUtils.getRtpDescription(content)).getMedia()) != null) {
            this.closeStream(MediaType.parseString((String)media));
        }
    }

    public void removeContent(String name) {
        this.removeContent(this.localContentMap, name);
        this.removeContent(this.remoteContentMap, name);
        TransportManagerJabberImpl transportManager = this.queryTransportManager();
        if (transportManager != null) {
            transportManager.removeContent(name);
        }
    }

    public void setRemotelyOnHold(boolean onHold) {
        this.remotelyOnHold = onHold;
        for (MediaType mediaType : MediaType.values()) {
            MediaStream stream = this.getStream(mediaType);
            if (stream == null) continue;
            if (((CallPeerJabberImpl)this.getPeer()).isJitsiVideobridge()) {
                ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType);
                MediaDirection direction = this.remotelyOnHold ? MediaDirection.INACTIVE : MediaDirection.SENDRECV;
                ((CallJabberImpl)((CallPeerJabberImpl)this.getPeer()).getCall()).setChannelDirection(channel.getID(), mediaType, direction);
                continue;
            }
            if (this.remotelyOnHold) {
                MediaDirection newDirection = ((CallJabberImpl)((CallPeerJabberImpl)this.getPeer()).getCall()).isConferenceFocus() ? MediaDirection.INACTIVE : stream.getDirection().and(MediaDirection.RECVONLY);
                stream.setDirection(newDirection);
                continue;
            }
            stream.setDirection(this.calculatePostHoldDirection(stream));
        }
    }

    public void setSupportQualityControls(boolean value) {
        this.supportQualityControls = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransportManager(String xmlns) throws IllegalArgumentException {
        if (this.transportManager != null && this.transportManager.getXmlNamespace().equals(xmlns)) {
            return;
        }
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        if (!((ProtocolProviderServiceJabberImpl)peer.getProtocolProvider()).getDiscoveryManager().includesFeature(xmlns)) {
            throw new IllegalArgumentException("Unsupported Jingle transport " + xmlns);
        }
        if (xmlns.equals("urn:xmpp:jingle:transports:ice-udp:1")) {
            this.transportManager = new IceUdpTransportManager(peer);
        } else if (xmlns.equals("urn:xmpp:jingle:transports:raw-udp:1")) {
            this.transportManager = new RawUdpTransportManager(peer);
        } else {
            throw new IllegalArgumentException("Unsupported Jingle transport " + xmlns);
        }
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            this.transportManagerSyncRoot.notify();
        }
    }

    public void start() throws IllegalStateException {
        try {
            this.wrapupConnectivityEstablishment();
        }
        catch (OperationFailedException ofe) {
            throw new UndeclaredThrowableException(ofe);
        }
        super.start();
    }

    protected void throwOperationFailedException(String message, int errorCode, Throwable cause) throws OperationFailedException {
        ProtocolProviderServiceJabberImpl.throwOperationFailedException(message, errorCode, cause, logger);
    }

    private void wrapupConnectivityEstablishment() throws OperationFailedException {
        TransportManagerJabberImpl transportManager = this.getTransportManager();
        transportManager.wrapupConnectivityEstablishment();
        for (MediaType mediaType : MediaType.values()) {
            MediaStream stream = this.getStream(mediaType);
            if (stream == null) continue;
            stream.setConnector(transportManager.getStreamConnector(mediaType));
            stream.setTarget(transportManager.getStreamTarget(mediaType));
        }
    }

    private ColibriConferenceIQ.Channel getColibriChannel(MediaType mediaType) {
        TransportManagerJabberImpl transportManager;
        ColibriConferenceIQ.Channel channel = null;
        if (((CallPeerJabberImpl)this.getPeer()).isJitsiVideobridge() && (transportManager = this.transportManager) != null) {
            channel = transportManager.getColibriChannel(mediaType, false);
        }
        return channel;
    }

    public boolean isRemotelyOnHold() {
        return this.remotelyOnHold;
    }

    public void setLocallyOnHold(boolean locallyOnHold) {
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        if (peer.isJitsiVideobridge()) {
            this.locallyOnHold = locallyOnHold;
            if (locallyOnHold || !CallPeerState.ON_HOLD_MUTUALLY.equals(peer.getState())) {
                for (MediaType mediaType : MediaType.values()) {
                    ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType);
                    if (channel == null) continue;
                    MediaDirection direction = locallyOnHold ? MediaDirection.INACTIVE : MediaDirection.SENDRECV;
                    ((CallJabberImpl)peer.getCall()).setChannelDirection(channel.getID(), mediaType, direction);
                }
            }
        } else {
            super.setLocallyOnHold(locallyOnHold);
        }
    }

    private boolean addDtlsAdvertisedEncryptions(boolean isInitiator, ContentPacketExtension content, MediaType mediaType) {
        if (((CallPeerJabberImpl)this.getPeer()).isJitsiVideobridge()) {
            return false;
        }
        IceUdpTransportPacketExtension remoteTransport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        return this.addDtlsAdvertisedEncryptions(isInitiator, remoteTransport, mediaType);
    }

    boolean addDtlsAdvertisedEncryptions(boolean isInitiator, IceUdpTransportPacketExtension remoteTransport, MediaType mediaType) {
        SrtpControl dtlsControl;
        AccountID accountID;
        List<DtlsFingerprintPacketExtension> remoteFingerpintPEs;
        SrtpControls srtpControls = this.getSrtpControls();
        boolean b = false;
        if (remoteTransport != null && !(remoteFingerpintPEs = remoteTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)).isEmpty() && (accountID = ((ProtocolProviderServiceJabberImpl)((CallPeerJabberImpl)this.getPeer()).getProtocolProvider()).getAccountID()).getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME)) {
            DtlsControl.Setup setup;
            DtlsControl dtlsControl2;
            LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
            for (DtlsFingerprintPacketExtension remoteFingerprintPE : remoteFingerpintPEs) {
                String remoteFingerprint = remoteFingerprintPE.getFingerprint();
                String remoteHash = remoteFingerprintPE.getHash();
                remoteFingerprints.put(remoteHash, remoteFingerprint);
            }
            if (isInitiator) {
                dtlsControl2 = (DtlsControl)srtpControls.get(mediaType, SrtpControlType.DTLS_SRTP);
                setup = DtlsControl.Setup.PASSIVE;
            } else {
                dtlsControl2 = (DtlsControl)srtpControls.getOrCreate(mediaType, SrtpControlType.DTLS_SRTP);
                setup = DtlsControl.Setup.ACTIVE;
            }
            if (dtlsControl2 != null) {
                dtlsControl2.setRemoteFingerprints(remoteFingerprints);
                dtlsControl2.setSetup(setup);
                this.removeAndCleanupOtherSrtpControls(mediaType, SrtpControlType.DTLS_SRTP);
                this.addAdvertisedEncryptionMethod(SrtpControlType.DTLS_SRTP);
                b = true;
            }
        }
        if (!b && (dtlsControl = srtpControls.get(mediaType, SrtpControlType.DTLS_SRTP)) != null) {
            srtpControls.remove(mediaType, SrtpControlType.DTLS_SRTP);
            dtlsControl.cleanup();
        }
        return b;
    }

    private void setAndAddPreferredEncryptionProtocol(MediaType mediaType, ContentPacketExtension localContent, ContentPacketExtension remoteContent) {
        List preferredEncryptionProtocols = ((ProtocolProviderServiceJabberImpl)((CallPeerJabberImpl)this.getPeer()).getProtocolProvider()).getAccountID().getSortedEnabledEncryptionProtocolList();
        for (String preferredEncryptionProtocol : preferredEncryptionProtocols) {
            RtpDescriptionPacketExtension remoteDescription;
            String protoName = preferredEncryptionProtocol.substring("ENCRYPTION_PROTOCOL".length() + 1);
            if (DtlsControl.PROTO_NAME.equals(protoName)) {
                this.addDtlsAdvertisedEncryptions(false, remoteContent, mediaType);
                if (!this.setDtlsEncryptionOnContent(mediaType, localContent, remoteContent)) continue;
                return;
            }
            RtpDescriptionPacketExtension localDescription = localContent == null ? null : JingleUtils.getRtpDescription(localContent);
            if (!this.setAndAddPreferredEncryptionProtocol(protoName, mediaType, localDescription, remoteDescription = remoteContent == null ? null : JingleUtils.getRtpDescription(remoteContent))) continue;
            return;
        }
    }

    private boolean setDtlsEncryptionOnContent(MediaType mediaType, ContentPacketExtension localContent, ContentPacketExtension remoteContent) {
        SrtpControl dtlsControl;
        DtlsControl dtlsControl2;
        boolean addFingerprintToLocalTransport;
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        boolean b = false;
        if (peer.isJitsiVideobridge()) {
            b = this.setDtlsEncryptionOnTransport(mediaType, localContent, remoteContent);
            return b;
        }
        ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)peer.getProtocolProvider();
        AccountID accountID = protocolProvider.getAccountID();
        SrtpControls srtpControls = this.getSrtpControls();
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME) && (addFingerprintToLocalTransport = remoteContent == null ? protocolProvider.isFeatureSupported(peer.getAddress(), "urn:xmpp:jingle:apps:dtls:0") : this.addDtlsAdvertisedEncryptions(false, remoteContent, mediaType)) && (dtlsControl2 = (DtlsControl)srtpControls.getOrCreate(mediaType, SrtpControlType.DTLS_SRTP)) != null) {
            DtlsControl.Setup setup = remoteContent == null ? DtlsControl.Setup.PASSIVE : DtlsControl.Setup.ACTIVE;
            dtlsControl2.setSetup(setup);
            b = true;
            this.setDtlsEncryptionOnTransport(mediaType, localContent, remoteContent);
        }
        if (!b && (dtlsControl = srtpControls.get(mediaType, SrtpControlType.DTLS_SRTP)) != null) {
            srtpControls.remove(mediaType, SrtpControlType.DTLS_SRTP);
            dtlsControl.cleanup();
        }
        return b;
    }

    private boolean setDtlsEncryptionOnTransport(MediaType mediaType, ContentPacketExtension localContent, ContentPacketExtension remoteContent) {
        IceUdpTransportPacketExtension localTransport = localContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
        boolean b = false;
        if (localTransport == null) {
            return b;
        }
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getPeer();
        if (peer.isJitsiVideobridge()) {
            ProtocolProviderServiceJabberImpl protocolProvider = (ProtocolProviderServiceJabberImpl)peer.getProtocolProvider();
            AccountID accountID = protocolProvider.getAccountID();
            if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(DtlsControl.PROTO_NAME)) {
                IceUdpTransportPacketExtension transport;
                ColibriConferenceIQ.Channel channel = this.getColibriChannel(mediaType);
                List<DtlsFingerprintPacketExtension> localFingerprints = null;
                if (channel != null && (transport = channel.getTransport()) != null) {
                    localFingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
                }
                if (localFingerprints != null && !localFingerprints.isEmpty()) {
                    if (remoteContent == null) {
                        if (!protocolProvider.isFeatureSupported(peer.getAddress(), "urn:xmpp:jingle:apps:dtls:0")) {
                            localFingerprints = null;
                        }
                    } else {
                        transport = remoteContent.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                        if (transport == null) {
                            localFingerprints = null;
                        } else {
                            List<DtlsFingerprintPacketExtension> remoteFingerprints = transport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
                            if (remoteFingerprints.isEmpty()) {
                                localFingerprints = null;
                            }
                        }
                    }
                    if (localFingerprints != null) {
                        List<DtlsFingerprintPacketExtension> fingerprintPEs = localTransport.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
                        if (fingerprintPEs.isEmpty()) {
                            for (DtlsFingerprintPacketExtension localFingerprint : localFingerprints) {
                                DtlsFingerprintPacketExtension fingerprintPE = new DtlsFingerprintPacketExtension();
                                fingerprintPE.setFingerprint(localFingerprint.getFingerprint());
                                fingerprintPE.setHash(localFingerprint.getHash());
                                localTransport.addChildExtension(fingerprintPE);
                            }
                        }
                        b = true;
                    }
                }
            }
        } else {
            SrtpControls srtpControls = this.getSrtpControls();
            DtlsControl dtlsControl = (DtlsControl)srtpControls.get(mediaType, SrtpControlType.DTLS_SRTP);
            if (dtlsControl != null) {
                CallJabberImpl.setDtlsEncryptionOnTransport(dtlsControl, localTransport);
                b = true;
            }
        }
        return b;
    }

    private void setDtlsEncryptionOnTransports(List<ContentPacketExtension> remoteContents, List<ContentPacketExtension> localContents) {
        for (ContentPacketExtension localContent : localContents) {
            MediaType mediaType;
            RtpDescriptionPacketExtension description = JingleUtils.getRtpDescription(localContent);
            if (description == null || (mediaType = JingleUtils.getMediaType(localContent)) == null) continue;
            ContentPacketExtension remoteContent = remoteContents == null ? null : TransportManagerJabberImpl.findContentByName(remoteContents, localContent.getName());
            this.setDtlsEncryptionOnTransport(mediaType, localContent, remoteContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSupportedTransports(Collection<String> transports) {
        if (transports == null) {
            return;
        }
        String ice = "urn:xmpp:jingle:transports:ice-udp:1";
        String rawUdp = "urn:xmpp:jingle:transports:raw-udp:1";
        int size = 0;
        for (String transport : transports) {
            if (!ice.equals(transport) && !rawUdp.equals(transport)) continue;
            ++size;
        }
        if (size > 0) {
            Object object = this.supportedTransportsSyncRoot;
            synchronized (object) {
                this.supportedTransports = new String[size];
                int i = 0;
                if (transports.contains(ice)) {
                    this.supportedTransports[i] = ice;
                    ++i;
                }
                if (transports.contains(rawUdp)) {
                    this.supportedTransports[i] = rawUdp;
                    ++i;
                }
            }
        }
    }
}

