/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.data;

import com.voxeo.data.Script;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    private String name;
    private int maxVersion;
    private boolean valid = true;
    Set<Script> scripts = new TreeSet<Script>(new Comparator<Script>(){

        @Override
        public int compare(Script s1, Script s2) {
            Integer a = s1.getVersion();
            Integer b = s2.getVersion();
            return a.compareTo(b);
        }
    });

    public void addScript(Script script) {
        Integer scriptVersion = script.getVersion();
        this.scripts.add(script);
        if (scriptVersion > this.maxVersion) {
            this.maxVersion = scriptVersion;
        }
        this.valid = this.maxVersion == this.scripts.size();
    }

    public Schema(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<Script> getScripts() {
        return Collections.unmodifiableSet(this.scripts);
    }
}

