/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.moho.media.output;

import com.voxeo.moho.media.output.AudibleResource;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TextToSpeechResource
extends AudibleResource {
    private static final Logger LOG = Logger.getLogger(TextToSpeechResource.class);
    protected String _text;
    protected Locale _locale;
    protected URI _uri;

    public TextToSpeechResource(String text) {
        this.setText(text, Locale.getDefault());
    }

    public TextToSpeechResource(String text, Locale locale) {
        this.setText(text, locale);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text, Locale locale) {
        this._text = text;
        this._locale = locale;
        try {
            this._uri = URI.create("data:" + URLEncoder.encode("application/ssml+xml,<?xml version=\"1.0\"?><speak><voice>" + this.getText() + "</voice>" + "</speak>", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"Exception when create URI from text", (Throwable)e);
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public URI toURI() {
        return this._uri;
    }
}

