/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.moho.media.input;

import com.voxeo.moho.media.BeepParameters;
import com.voxeo.moho.media.EnergyParameters;
import com.voxeo.moho.media.InputMode;
import com.voxeo.moho.media.input.Grammar;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.resource.RTC;

public class InputCommand
implements Parameters {
    protected int _signalNumber = -1;
    protected Grammar[] _grammars = new Grammar[0];
    protected float _minConfidence = 0.3f;
    protected float _sensitivity = 0.5f;
    protected long _initialTimeout = -1L;
    protected long _interSigTimeout = -1L;
    protected long _maxTimeout = -1L;
    protected boolean _record = false;
    protected URI _recordURI = null;
    protected boolean _buffering = true;
    protected Parameters _parameters;
    protected RTC[] _rtcs;
    protected Map<Parameter, Object> _parametersExt = new HashMap<Parameter, Object>();
    protected Set<RTC> _rtcsExt = new HashSet<RTC>();
    protected String _recognizer;
    protected Character _terminator;
    protected InputMode _inputMode;
    protected boolean _dtmfHotword = false;
    protected boolean _dtmfTypeahead = false;
    protected boolean _supervised = true;
    protected long _speechIncompleteTimeout;
    protected long _speechCompleteTimeout;
    protected boolean _flushBuffer;
    protected boolean _autoreset;
    protected EnergyParameters _energyParams = new EnergyParameters();
    protected BeepParameters _beepParams = new BeepParameters();
    protected boolean _ignorePromptFailure;

    public InputCommand(String grammer) {
        if (grammer == null || grammer.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._grammars = new Grammar[]{Grammar.create(grammer)};
    }

    public InputCommand(Grammar ... grammars) {
        if (grammars != null && grammars.length > 0) {
            this._grammars = grammars;
        }
    }

    public long getInterDigitsTimeout() {
        return this._interSigTimeout;
    }

    public void setInterDigitsTimeout(long time) {
        this._interSigTimeout = time;
    }

    public boolean isBuffering() {
        return this._buffering;
    }

    public void setBuffering(boolean buffering) {
        this._buffering = buffering;
    }

    public int getNumberOfDigits() {
        return this._signalNumber;
    }

    public void setNumberOfDigits(int num) {
        this._signalNumber = num < 0 ? -1 : num;
    }

    public Grammar[] getGrammars() {
        return this._grammars;
    }

    public float getMinConfidence() {
        return this._minConfidence;
    }

    public boolean isRecord() {
        return this._record;
    }

    public void setRecord(boolean flag) {
        this._record = flag;
    }

    public URI getRecordURI() {
        return this._recordURI;
    }

    public void setRecordURI(URI uri) {
        this._recordURI = uri;
    }

    public float getSensitivity() {
        return this._sensitivity;
    }

    public void setSensitivity(float _sensitivity) {
        this._sensitivity = _sensitivity;
    }

    public void setMinConfidence(float confidence) {
        if (confidence < 0.0f) {
            throw new IllegalArgumentException("Confidence must be greater than 0.");
        }
        if (confidence > 1.0f) {
            throw new IllegalArgumentException("Confidence must be less than 1.");
        }
        this._minConfidence = confidence;
    }

    public long getInitialTimeout() {
        return this._initialTimeout;
    }

    public void setInitialTimeout(long time) {
        this._initialTimeout = time;
    }

    public long getMaxTimeout() {
        return this._maxTimeout;
    }

    public void setMaxTimeout(long time) {
        this._maxTimeout = time;
    }

    public void setSupervised(boolean supervised) {
        this._supervised = supervised;
    }

    public boolean isSupervised() {
        return this._supervised;
    }

    public String getRecognizer() {
        return this._recognizer;
    }

    public void setRecognizer(String recognizer) {
        this._recognizer = recognizer;
    }

    public Character getTerminator() {
        return this._terminator;
    }

    public void setTerminator(Character termChar) {
        this._terminator = termChar;
    }

    public InputMode getInputMode() {
        return this._inputMode;
    }

    public void setInputMode(InputMode inputMode) {
        this._inputMode = inputMode;
    }

    @Deprecated
    public Parameters getParameters() {
        return this._parameters;
    }

    @Deprecated
    public void setParameters(Parameters parameters) {
        this._parameters = parameters;
    }

    @Deprecated
    public RTC[] getRtcs() {
        return this._rtcs;
    }

    @Deprecated
    public void setRtcs(RTC[] rtcs) {
        this._rtcs = rtcs;
    }

    public boolean addRTC(RTC o) {
        return this._rtcsExt.add(o);
    }

    public boolean addAllRTC(Collection<? extends RTC> c) {
        return this._rtcsExt.addAll(c);
    }

    public void removeAllRTC() {
        this._rtcsExt.clear();
    }

    public boolean removeRTC(Object o) {
        return this._rtcsExt.remove(o);
    }

    public Set<RTC> getAllRTC() {
        return this._rtcsExt;
    }

    public void clear() {
        this._parametersExt.clear();
    }

    public boolean containsKey(Object key) {
        return this._parametersExt.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._parametersExt.containsValue(value);
    }

    public Set<Map.Entry<Parameter, Object>> entrySet() {
        return this._parametersExt.entrySet();
    }

    public Object get(Object key) {
        return this._parametersExt.get(key);
    }

    public boolean isEmpty() {
        return this._parametersExt.isEmpty();
    }

    public Set<Parameter> keySet() {
        return this._parametersExt.keySet();
    }

    public Object put(Parameter key, Object value) {
        return this._parametersExt.put(key, value);
    }

    public void putAll(Map<? extends Parameter, ? extends Object> t) {
        this._parametersExt.putAll(t);
    }

    public Object remove(Object key) {
        return this._parametersExt.remove(key);
    }

    public int size() {
        return this._parametersExt.size();
    }

    public Collection<Object> values() {
        return this._parametersExt.values();
    }

    public boolean isDtmfHotword() {
        return this._dtmfHotword;
    }

    public void setDtmfHotword(boolean dtmfHotword) {
        this._dtmfHotword = dtmfHotword;
    }

    public boolean isDtmfTypeahead() {
        return this._dtmfTypeahead;
    }

    public void setDtmfTypeahead(boolean dtmfTypeahead) {
        this._dtmfTypeahead = dtmfTypeahead;
    }

    public long getSpeechIncompleteTimeout() {
        return this._speechIncompleteTimeout;
    }

    public void setSpeechIncompleteTimeout(long speechIncompleteTimeout) {
        this._speechIncompleteTimeout = speechIncompleteTimeout;
    }

    public long getSpeechCompleteTimeout() {
        return this._speechCompleteTimeout;
    }

    public void setSpeechCompleteTimeout(long speechCompleteTimeout) {
        this._speechCompleteTimeout = speechCompleteTimeout;
    }

    public boolean isFlushBuffer() {
        return this._flushBuffer;
    }

    public void setFlushBuffer(boolean flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public boolean getAutoReset() {
        return this._autoreset;
    }

    public void setAutoRest(boolean autoreset) {
        this._autoreset = autoreset;
    }

    public void setEnergyParameters(Long finalSilence, Long maxSilence, Long maxSpeechDuration, Long minSpeechDuration, Integer minVolume) {
        if (finalSilence != null) {
            this._energyParams.setFinalSilence(finalSilence);
        }
        if (maxSilence != null) {
            this._energyParams.setMaxSilence(maxSilence);
        }
        if (maxSpeechDuration != null) {
            this._energyParams.setMaxSpeechDuration(maxSpeechDuration);
        }
        if (minSpeechDuration != null) {
            this._energyParams.setMinSpeechDuration(minSpeechDuration);
        }
        if (minVolume != null) {
            this._energyParams.setMinVolume(minVolume);
        }
    }

    public EnergyParameters getEnergyParameters() {
        return this._energyParams;
    }

    public void setBeepParameters(Long onTime, Long offTime, Long minFrequency, Long maxFrequency, Float frequencyTolerance, Float monotonicity, Float signalToNoise, Float highMonotonicity, Integer minPower, Long maxNoiseTime, Long maxConsequitiveNoiseTime) {
        if (onTime != null) {
            this._beepParams.setOnTime(onTime);
        }
        if (offTime != null) {
            this._beepParams.setOffTime(offTime);
        }
        if (minFrequency != null) {
            this._beepParams.setMinFrequency(minFrequency);
        }
        if (maxFrequency != null) {
            this._beepParams.setMaxFrequency(maxFrequency);
        }
        if (monotonicity != null) {
            this._beepParams.setMonotonicity(monotonicity.floatValue());
        }
        if (signalToNoise != null) {
            this._beepParams.setSignalToNoise(signalToNoise.floatValue());
        }
        if (highMonotonicity != null) {
            this._beepParams.setHighMonotonicity(highMonotonicity.floatValue());
        }
        if (minPower != null) {
            this._beepParams.setMinPower(minPower);
        }
        if (maxNoiseTime != null) {
            this._beepParams.setMaxNoiseTime(maxNoiseTime);
        }
        if (maxConsequitiveNoiseTime != null) {
            this._beepParams.setMaxConsecutiveNoiseTime(maxConsequitiveNoiseTime);
        }
    }

    public BeepParameters getBeepParameters() {
        return this._beepParams;
    }

    public boolean isIgnorePromptFailure() {
        return this._ignorePromptFailure;
    }

    public void setIgnorePromptFailure(boolean ignorePromptFailure) {
        this._ignorePromptFailure = ignorePromptFailure;
    }
}

