/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.relp.SampleInfo;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class AudioOutput
implements UtteranceProcessor {
    private static final Logger LOGGER = Logger.getLogger(AudioOutput.class.getName());
    private static final AudioFormat AUDIO_8KHZ = new AudioFormat(8000.0f, 16, 1, true, true);
    private static final AudioFormat AUDIO_16KHZ = new AudioFormat(16000.0f, 16, 1, true, true);

    @Override
    public void processUtterance(Utterance utterance) throws ProcessException {
        LPCResult lpcResult = (LPCResult)utterance.getObject("target_lpcres");
        SampleInfo sampleInfo = (SampleInfo)utterance.getObject("SampleInfo");
        AudioPlayer audioPlayer = utterance.getVoice().getAudioPlayer();
        audioPlayer.setAudioFormat(this.getAudioFormat(sampleInfo));
        audioPlayer.setVolume(utterance.getVoice().getVolume());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("=== " + utterance.getString("input_text"));
        }
        try {
            if (!lpcResult.playWave(audioPlayer, utterance)) {
                throw new ProcessException("Output Cancelled");
            }
        }
        catch (IOException e) {
            throw new ProcessException(e.getMessage(), e);
        }
    }

    private AudioFormat getAudioFormat(SampleInfo sampleInfo) {
        if (sampleInfo.getSampleRate() == 8000) {
            return AUDIO_8KHZ;
        }
        if (sampleInfo.getSampleRate() == 16000) {
            return AUDIO_16KHZ;
        }
        return new AudioFormat(sampleInfo.getSampleRate(), 16, 1, true, true);
    }

    public String toString() {
        return "AudioOutput";
    }
}

