/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.BulkTimer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class NullAudioPlayer
implements AudioPlayer {
    private static final Logger LOGGER = Logger.getLogger(NullAudioPlayer.class.getName());
    private float volume = 1.0f;
    private AudioFormat audioFormat;
    private boolean firstSound = true;
    private int totalBytes = 0;
    private int totalWrites = 0;
    private BulkTimer timer = new BulkTimer();

    @Override
    public void setAudioFormat(AudioFormat format) {
        this.audioFormat = format;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void reset() {
        this.timer.start("AudioOutput");
    }

    @Override
    public void resume() {
    }

    @Override
    public void close() {
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
    }

    @Override
    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    @Override
    public void begin(int size) {
    }

    @Override
    public boolean end() {
        return true;
    }

    @Override
    public boolean write(byte[] bytes, int offset, int size) {
        this.totalBytes += size;
        ++this.totalWrites;
        if (this.firstSound) {
            this.timer.stop("AudioFirstSound");
            this.firstSound = false;
            if (LOGGER.isLoggable(Level.FINER)) {
                this.timer.show("Null Trace");
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.fine("NullAudio: write " + size + " bytes.");
        }
        return true;
    }

    @Override
    public void startFirstSampleTimer() {
        this.firstSound = true;
        this.timer.start("AudioFirstSound");
    }

    @Override
    public boolean drain() {
        this.timer.stop("AudioOutput");
        return true;
    }

    @Override
    public long getTime() {
        return -1L;
    }

    @Override
    public void resetTime() {
    }

    @Override
    public void showMetrics() {
        this.timer.show("NullAudioPlayer");
    }
}

