/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.IFilter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    private boolean dirty = true;
    private List<T> delegate;
    private List<Integer> filteredList;
    private IFilter<T> filter;

    public FilteringArrayList() {
        this(10);
    }

    public FilteringArrayList(int capacity) {
        this(new ArrayList(capacity));
    }

    public FilteringArrayList(List<T> delegate) {
        this.filteredList = new ArrayList<Integer>(delegate.size());
        this.filter = new IFilter<T>(){

            @Override
            public boolean accept(T t) {
                return true;
            }
        };
        this.delegate = delegate;
    }

    public FilteringArrayList(Collection<T> col) {
        this(col.size());
        this.delegate.addAll(col);
    }

    public void setFilter(IFilter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("null filter");
        }
        this.filter = filter;
        this.dirty = true;
    }

    private void filter() {
        this.filteredList.clear();
        for (int i = 0; i < this.delegate.size(); ++i) {
            T t = this.delegate.get(i);
            if (!this.filter.accept(t)) continue;
            this.filteredList.add(i);
        }
        this.dirty = false;
    }

    @Override
    public T get(int index) {
        if (this.dirty) {
            this.filter();
        }
        return this.delegate.get(this.filteredList.get(index));
    }

    @Override
    public int size() {
        if (this.dirty) {
            this.filter();
        }
        return this.filteredList.size();
    }

    @Override
    public boolean add(T o) {
        if (this.dirty) {
            this.filter();
        }
        this.delegate.add(o);
        if (this.filter.accept(o)) {
            this.filteredList.add(this.delegate.size() - 1);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            if (this.add(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.filteredList.clear();
        this.dirty = false;
    }
}

