/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferProgressEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferProgressListener;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractFileTransfer
implements FileTransfer {
    private static final Logger logger = Logger.getLogger(AbstractFileTransfer.class);
    private Vector<FileTransferStatusListener> statusListeners = new Vector();
    private Vector<FileTransferProgressListener> progressListeners = new Vector();
    private int status;

    @Override
    public abstract void cancel();

    @Override
    public abstract long getTransferedBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProgressListener(FileTransferProgressListener listener) {
        Vector<FileTransferProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            if (!this.progressListeners.contains(listener)) {
                this.progressListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusListener(FileTransferStatusListener listener) {
        Vector<FileTransferStatusListener> vector = this.statusListeners;
        synchronized (vector) {
            if (!this.statusListeners.contains(listener)) {
                this.statusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProgressListener(FileTransferProgressListener listener) {
        Vector<FileTransferProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            this.progressListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusListener(FileTransferStatusListener listener) {
        Vector<FileTransferStatusListener> vector = this.statusListeners;
        synchronized (vector) {
            this.statusListeners.remove(listener);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void fireStatusChangeEvent(int newStatus) {
        this.fireStatusChangeEvent(newStatus, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStatusChangeEvent(int newStatus, String reason) {
        if (this.status == newStatus) {
            return;
        }
        ArrayList<FileTransferStatusListener> listeners = null;
        Vector<FileTransferStatusListener> vector = this.statusListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferStatusListener>(this.statusListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a FileTransfer Event to" + listeners.size() + " listeners. Status=" + this.status));
        }
        FileTransferStatusChangeEvent statusEvent = new FileTransferStatusChangeEvent(this, this.status, newStatus, reason);
        this.status = newStatus;
        for (FileTransferStatusListener statusListener : listeners) {
            statusListener.statusChanged(statusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProgressChangeEvent(long timestamp, long progress) {
        ArrayList<FileTransferProgressListener> listeners = null;
        Vector<FileTransferProgressListener> vector = this.progressListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferProgressListener>(this.progressListeners);
        }
        FileTransferProgressEvent progressEvent = new FileTransferProgressEvent(this, timestamp, progress);
        for (FileTransferProgressListener statusListener : listeners) {
            statusListener.progressChanged(progressEvent);
        }
    }
}

