/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.client;

import com.hazelcast.client.SecureRequest;
import com.hazelcast.concurrent.lock.client.AbstractUnlockRequest;
import com.hazelcast.map.MapPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;
import java.security.Permission;

public class MapUnlockRequest
extends AbstractUnlockRequest
implements SecureRequest {
    private String name;

    public MapUnlockRequest() {
    }

    public MapUnlockRequest(String name, Data key, int threadId) {
        super(key, threadId, false);
        this.name = name;
    }

    public MapUnlockRequest(String name, Data key, int threadId, boolean force) {
        super(key, threadId, force);
        this.name = name;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected ObjectNamespace getNamespace() {
        return new DefaultObjectNamespace("hz:impl:mapService", this.name);
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        super.writePortable(writer);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        super.readPortable(reader);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "lock");
    }
}

