/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.dcc;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

public class DccSendHandler
extends Thread {
    static Logger log = Logger.getLogger(DccSendHandler.class);
    private Socket socket_;
    private String filename_;
    private int filesize_;
    private static final int DEFAULT_BUF_SIZE = 5000;
    private static int count = 0;

    private static synchronized int nextCount() {
        return count++;
    }

    public DccSendHandler(Socket socket, String filename, int filesize) {
        super("dcchandler-" + DccSendHandler.nextCount());
        this.socket_ = socket;
        this.filename_ = filename;
        this.filesize_ = filesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDccSend(Socket socket, String filename, int filesize) throws IOException {
        OutputStream dest = this.getStreamForReceive(filename, filesize);
        log.debug((Object)("DccSendHandler: handleDcc in thread: " + Thread.currentThread().getName()));
        InputStream incoming = socket.getInputStream();
        OutputStream outgoing = socket.getOutputStream();
        byte[] buffer = new byte[5000];
        byte[] intbuf = new byte[4];
        int totalin = 0;
        try {
            int recvd;
            while ((recvd = incoming.read(buffer)) >= 0) {
                dest.write(buffer, 0, recvd);
                intbuf[0] = (byte)((totalin += recvd) >>> 24 & 0xFF);
                intbuf[1] = (byte)(totalin >>> 16 & 0xFF);
                intbuf[2] = (byte)(totalin >>> 8 & 0xFF);
                intbuf[3] = (byte)(totalin & 0xFF);
                outgoing.write(intbuf);
                outgoing.flush();
            }
        }
        finally {
            dest.close();
        }
        log.debug((Object)("DccSendHandler: Done writing file: " + filename));
        log.debug((Object)("DccSendHandler: Total bytes: " + totalin));
        socket.close();
    }

    protected OutputStream getStreamForReceive(String filename, int filesize) throws IOException {
        throw new FileNotFoundException("Refusing to write '" + filename + "'");
    }

    public void run() {
        try {
            this.handleDccSend(this.socket_, this.filename_, this.filesize_);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

