/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icon;

import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joscar.snaccmd.icon.IconCommand;
import net.kano.joscar.snaccmd.icon.IconDataCmd;
import net.kano.joscar.snaccmd.icon.IconRequest;
import net.kano.joscar.snaccmd.icon.UploadIconAck;
import net.kano.joscar.snaccmd.icon.UploadIconCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestHandler;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconSetListener;

public class IconService
extends Service
implements IconRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(IconService.class.getName());
    private CopyOnWriteArrayList<IconRequestListener> listeners = new CopyOnWriteArrayList();

    public void addIconRequestListener(IconRequestListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    public void removeIconRequestListener(IconRequestListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected IconService(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 16);
        ClientSnacProcessor snacProcessor = oscarConnection.getSnacProcessor();
        snacProcessor.addGlobalResponseListener(new SnacResponseListener(){

            public void handleResponse(SnacResponseEvent e) {
                block4: {
                    SnacCommand cmd = e.getSnacCommand();
                    if (!(cmd instanceof IconDataCmd)) break block4;
                    IconDataCmd iconDataCmd = (IconDataCmd)cmd;
                    ExtraInfoBlock iconInfo = iconDataCmd.getIconInfo();
                    ExtraInfoData data = iconInfo.getExtraData();
                    ByteBlock hash = data.getData();
                    Screenname sn = new Screenname(iconDataCmd.getScreenname());
                    if ((data.getFlags() & 1) == 0 && hash.equals((Object)ExtraInfoData.HASH_SPECIAL)) {
                        for (IconRequestListener listener : IconService.this.listeners) {
                            listener.buddyIconCleared(IconService.this, sn, data);
                        }
                    } else {
                        for (IconRequestListener listener : IconService.this.listeners) {
                            listener.buddyIconUpdated(IconService.this, sn, data, iconDataCmd.getIconData());
                        }
                    }
                }
            }
        });
    }

    public SnacFamilyInfo getSnacFamilyInfo() {
        return IconCommand.FAMILY_INFO;
    }

    public void connected() {
        this.setReady();
    }

    public void requestIcon(Screenname sn, ExtraInfoData block) {
        this.sendSnac((SnacCommand)new IconRequest(sn.getFormatted(), block));
    }

    public void uploadIcon(Writable data) {
        this.uploadIcon(data, null);
    }

    public void uploadIcon(final Writable data, final IconSetListener listener) {
        LOGGER.fine("Uploading icon " + data);
        this.sendSnacRequest((SnacCommand)new UploadIconCmd(data), (SnacRequestListener)new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                SnacCommand cmd = e.getSnacCommand();
                if (cmd instanceof UploadIconAck) {
                    ExtraInfoBlock iconInfo;
                    UploadIconAck iconAck = (UploadIconAck)cmd;
                    if (iconAck.getCode() != 0) {
                        LOGGER.fine("Got unknown code from UploadIconAck: " + iconAck);
                    }
                    if ((iconInfo = iconAck.getIconInfo()) == null) {
                        LOGGER.finer("Got icon ack with no iconInfo: " + iconAck);
                    }
                    if (listener != null) {
                        LOGGER.fine("Successfully set icon " + data);
                        listener.handleIconSet(IconService.this, data, true);
                    }
                } else if (cmd instanceof SnacError) {
                    LOGGER.warning("Got SnacError while setting icon: " + cmd);
                    listener.handleIconSet(IconService.this, data, false);
                }
            }
        });
    }
}

