/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.kano.joscar.rvcmd.SegmentedFilename;
import net.kano.joscar.rvproto.ft.FileTransferHeader;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Checksummer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FailureEventException;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingFileTransferPlumber;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.OutgoingFileTransferPlumberImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TransferredFile;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.Transferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ChecksummingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.CorruptTransferEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.FileCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ResumeChecksumFailedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferredFileInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.TransferringFileEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.UnknownErrorEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.TransferSucceededInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendFileController
extends TransferController {
    private static final Logger LOGGER = Logger.getLogger(SendFileController.class.getName());
    private OutgoingFileTransferPlumber plumber;

    public void setPlumber(OutgoingFileTransferPlumber plumber) {
        this.plumber = plumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void transferInThread(RvConnection transfer) throws IOException, FailureEventException {
        OutgoingFileTransfer otransfer = (OutgoingFileTransfer)transfer;
        RvSessionConnectionInfo rvConnectionInfo = transfer.getRvSessionInfo();
        EventPost eventPost = otransfer.getEventPost();
        if (this.plumber == null) {
            this.plumber = new OutgoingFileTransferPlumberImpl(otransfer, this);
        }
        List<TransferredFile> rafs = this.plumber.getFilesToTransfer();
        try {
            long totalSize = SendFileController.getTotalSize(rafs);
            int fileCount = rafs.size();
            int left = fileCount + 1;
            int succeeded = 0;
            for (TransferredFile mfile : rafs) {
                FileTransferHeader receivedHeader;
                long startAt;
                --left;
                long len = mfile.getSize();
                this.pauseTimeout();
                long fileChecksum = otransfer.getChecksummer().getChecksum(mfile);
                this.resumeTimeout();
                FileTransferHeader sendheader = new FileTransferHeader();
                sendheader.setDefaults();
                sendheader.setFilename(SegmentedFilename.fromNativeFilename((String)mfile.getTransferredName()));
                sendheader.setHeaderType(257);
                sendheader.setChecksum(fileChecksum);
                sendheader.setReceivedChecksum(0xFFFF0000L);
                sendheader.setFileCount(fileCount);
                sendheader.setFileSize(len);
                sendheader.setFilesLeft(left);
                sendheader.setLastmod(mfile.getLastModifiedMillis() / 1000L);
                sendheader.setPartCount(1);
                sendheader.setPartsLeft(1);
                sendheader.setMacFileInfo(mfile.getMacFileInfo());
                sendheader.setResForkChecksum(0xFFFF0000L);
                sendheader.setResForkReceivedChecksum(0xFFFF0000L);
                sendheader.setListNameOffset(28);
                sendheader.setListSizeOffset(17);
                sendheader.setTotalFileSize(totalSize);
                long rvSessionId = rvConnectionInfo.getRvSession().getRvSessionId();
                if (rvConnectionInfo.getInitiator() == Initiator.BUDDY) {
                    sendheader.setIcbmMessageId(rvSessionId);
                }
                this.plumber.sendHeader(sendheader);
                FileTransferHeader ack = this.plumber.readHeader();
                if (ack == null) {
                    LOGGER.warning("Couldn't read file transfer header, closing");
                    break;
                }
                if (rvConnectionInfo.getInitiator() == Initiator.ME && ack.getIcbmMessageId() != rvSessionId) {
                    LOGGER.warning("Buddy sent wrong ICBM message ID: " + ack.getIcbmMessageId() + " should have been " + rvSessionId);
                    this.fireFailed(new UnknownErrorEvent());
                    break;
                }
                this.setConnected();
                int headerType = ack.getHeaderType();
                if (headerType == 517) {
                    long respondStartAt;
                    long attemptStartAt = ack.getBytesReceived();
                    long attemptChecksum = ack.getReceivedChecksum();
                    Checksummer rsummer = this.plumber.getChecksummer(mfile, attemptStartAt);
                    eventPost.fireEvent(new ChecksummingEvent(mfile, rsummer));
                    long oursum = rsummer.compute();
                    if (oursum != attemptChecksum) {
                        eventPost.fireEvent(new ResumeChecksumFailedEvent(mfile));
                        respondStartAt = 0L;
                    } else {
                        respondStartAt = attemptStartAt;
                    }
                    FileTransferHeader resumeSend = new FileTransferHeader(sendheader);
                    resumeSend.setBytesReceived(respondStartAt);
                    resumeSend.setChecksum(fileChecksum);
                    resumeSend.setHeaderType(262);
                    this.plumber.sendHeader(resumeSend);
                    FileTransferHeader resumeAck = this.plumber.readHeader();
                    if (resumeAck.getHeaderType() != 519) break;
                    startAt = resumeAck.getBytesReceived();
                } else {
                    if (headerType != 514) break;
                    startAt = 0L;
                }
                long toSend = len - startAt;
                Transferrer sender = this.plumber.createTransferrer(mfile, startAt, len);
                assert (sender != null) : this.plumber;
                TransferredFileInfo info = new TransferredFileInfo(mfile, len, startAt);
                eventPost.fireEvent(new TransferringFileEvent(info, sender));
                long sent = sender.transfer();
                mfile.close();
                if (sent != toSend || (receivedHeader = this.plumber.readHeader()) == null) break;
                if (receivedHeader.getBytesReceived() != len || receivedHeader.getChecksum() != fileChecksum) {
                    this.fireFailed(new CorruptTransferEvent(info));
                    break;
                }
                eventPost.fireEvent(new FileCompleteEvent(info));
                ++succeeded;
            }
            if (succeeded == rafs.size()) {
                this.fireSucceeded(new TransferSucceededInfo(rafs));
            } else {
                this.fireFailed(new UnknownErrorEvent());
            }
        }
        finally {
            for (TransferredFile file : rafs) {
                try {
                    file.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static long getTotalSize(List<TransferredFile> rafs) {
        long totalSize = 0L;
        for (TransferredFile file : rafs) {
            totalSize += file.getSize();
        }
        return totalSize;
    }
}

