/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.rvcmd.sendfile.FileSendBlock;
import net.kano.joscar.rvcmd.sendfile.FileSendReqRvCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.MutableSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.AbstractIncomingRvSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.DefaultFileMapper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileMapper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferHelper;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferRequestMaker;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvRequestMaker;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ReceiveFileController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;

public class IncomingFileTransferImpl
extends IncomingRvConnectionImpl
implements IncomingFileTransfer {
    private static final Logger LOGGER = Logger.getLogger(IncomingFileTransferImpl.class.getName());
    private FileMapper fileMapper;
    private FileTransferHelper helper = new FileTransferHelper(this);

    IncomingFileTransferImpl(AimProxyInfo proxy, Screenname screenname, RvSessionConnectionInfo rvsessioninfo) {
        super(proxy, screenname, rvsessioninfo);
        this.fileMapper = new DefaultFileMapper(this.getBuddyScreenname(), System.getProperty("user.dir"));
    }

    public IncomingFileTransferImpl(AimProxyInfo proxy, Screenname screenname, RvSession session) {
        this(proxy, screenname, new MutableSessionConnectionInfo(session));
        ((MutableSessionConnectionInfo)this.getRvSessionInfo()).setMaker(new FileTransferRequestMaker(this));
    }

    protected RendezvousSessionHandler createSessionHandler() {
        return new IncomingFtRvSessionHandler();
    }

    public synchronized void setFileMapper(FileMapper mapper) {
        this.fileMapper = mapper;
    }

    public synchronized FileMapper getFileMapper() {
        return this.fileMapper;
    }

    protected ConnectedController createConnectedController(StateInfo endState) {
        return new ReceiveFileController();
    }

    protected boolean isConnectedController(StateController controller) {
        return controller instanceof ReceiveFileController;
    }

    protected NextStateControllerInfo getNextControllerFromSuccess(StateController oldController, StateInfo oldStateInfo) {
        if (oldController instanceof ReceiveFileController) {
            LOGGER.fine("Changing from success of receive controller to completed");
            return new NextStateControllerInfo(RvConnectionState.FINISHED, (RvConnectionEvent)new ConnectionCompleteEvent());
        }
        if (oldStateInfo instanceof StreamInfo) {
            throw new IllegalStateException("stream info here??");
        }
        throw new IllegalStateException("Unknown last controller " + oldController);
    }

    protected NextStateControllerInfo getNextControllerFromUnknownError(StateController oldController, StateInfo oldState, RvConnectionEvent event) {
        if (oldController instanceof ReceiveFileController) {
            return new NextStateControllerInfo(RvConnectionState.FAILED, event);
        }
        throw new IllegalStateException("Unknown controller " + oldController);
    }

    public RvRequestMaker getRvRequestMaker() {
        return this.helper.getRvRequestMaker();
    }

    public InvitationMessage getInvitationMessage() {
        return this.helper.getInvitationMessage();
    }

    private void setInvitationMessage(InvitationMessage msg) {
        this.helper.setInvitationMessage(msg);
    }

    public FileSendBlock getRequestFileInfo() {
        return this.helper.getFileInfo();
    }

    private void setFileInfo(FileSendBlock block) {
        this.helper.setFileInfo(block);
    }

    private class IncomingFtRvSessionHandler
    extends AbstractIncomingRvSessionHandler {
        public IncomingFtRvSessionHandler() {
            super(IncomingFileTransferImpl.this);
        }

        protected void handleFirstRequest(ConnectionRequestRvCmd reqCmd) {
            FileSendReqRvCmd ftcmd = (FileSendReqRvCmd)reqCmd;
            IncomingFileTransferImpl.this.setFileInfo(ftcmd.getFileSendBlock());
            IncomingFileTransferImpl.this.setInvitationMessage(ftcmd.getMessage());
        }
    }
}

