/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.mailcheck;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.mailcheck.ActivateMailCmd;
import net.kano.joscar.snaccmd.mailcheck.MailStatusRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMailCheckCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(24, 6), new CmdType(24, 22));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 24) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 6) {
            return new MailStatusRequest(packet);
        }
        if (command == 22) {
            return new ActivateMailCmd(packet);
        }
        return null;
    }
}

