/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.AbstractChatInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public final class FullRoomInfo
extends AbstractChatInfo
implements LiveWritable {
    public static final int INSTANCE_LAST = 65535;
    private static final int TYPE_ROOM_NAME = 106;
    private static final int CODE_DEFAULT = 0;
    private MiniRoomInfo mini = null;
    private final int exchange;
    private final String cookie;
    private final int instance;
    private final int type;
    private final int code;
    private final String roomName;

    public static FullRoomInfo readRoomInfo(ByteBlock byteBlock) {
        return new FullRoomInfo(byteBlock);
    }

    private FullRoomInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        this.mini = MiniRoomInfo.readMiniRoomInfo(byteBlock);
        this.exchange = this.mini.getExchange();
        this.cookie = this.mini.getCookie();
        this.instance = this.mini.getInstance();
        ByteBlock byteBlock2 = byteBlock.subBlock(this.mini.getTotalSize());
        this.type = BinaryTools.getUByte(byteBlock2, 0);
        this.code = BinaryTools.getUShort(byteBlock2, 1);
        ByteBlock byteBlock3 = byteBlock2.subBlock(3);
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock3);
        this.roomName = immutableTlvChain.getString(106);
        this.readBaseInfo(immutableTlvChain);
    }

    public FullRoomInfo(int n, String string) {
        this(n, string, "us-ascii", Locale.getDefault().getLanguage());
    }

    public FullRoomInfo(int n, String string, String string2, String string3) {
        this(n, string, string2, string3, null);
    }

    public FullRoomInfo(int n, String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        DefensiveTools.checkRange(n, "exchange", 0);
        this.exchange = n;
        this.cookie = "create";
        this.instance = 65535;
        this.type = 1;
        this.code = 0;
        this.roomName = null;
    }

    public final int getExchange() {
        return this.exchange;
    }

    public final String getCookie() {
        return this.cookie;
    }

    public final int getInstance() {
        return this.instance;
    }

    public final int getType() {
        return this.type;
    }

    public final String getRoomName() {
        return this.roomName;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.mini == null) {
            this.mini = new MiniRoomInfo(this);
        }
        this.mini.write(outputStream);
        BinaryTools.writeUByte(outputStream, this.type);
        BinaryTools.writeUShort(outputStream, this.code);
        this.writeBaseInfo(outputStream);
        if (this.roomName != null) {
            Tlv.getStringInstance(106, this.roomName).write(outputStream);
        }
    }

    public String toString() {
        return "FullRoomInfo: " + this.roomName + " on ex." + this.exchange + ", instance=" + this.instance + ", cookie=" + this.cookie + ", type=" + this.type + " - " + super.toString();
    }
}

