/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.net.ConnProcessor;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnacRequest {
    public static final ConnProcessor.ErrorType ERRTYPE_SNAC_RESPONSE_LISTENER = new ConnProcessor.ErrorType("ERRTYPE_SNAC_RESPONSE_LISTENER");
    private static final Logger logger = LoggingSystem.getLogger("net.kano.joscar.snac");
    private final SnacCommand command;
    private List<SnacRequestListener> listeners = null;
    private final Object listenerEventLock = new Object();
    private List<SnacResponseEvent> responses = null;
    private long sentAt = -1L;
    private long reqid = -1L;
    private boolean storingResponses = false;

    public SnacRequest(SnacCommand snacCommand, SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacCommand, "command");
        this.command = snacCommand;
        if (snacRequestListener != null) {
            this.addListener(snacRequestListener);
        }
    }

    final void setReqid(long l) {
        this.reqid = l;
    }

    final long getReqid() {
        return this.reqid;
    }

    public final synchronized void addListener(SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacRequestListener, "l");
        if (this.listeners == null) {
            this.listeners = new ArrayList<SnacRequestListener>(4);
        }
        this.listeners.add(snacRequestListener);
    }

    public final synchronized void removeListener(SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacRequestListener, "l");
        if (this.listeners != null) {
            this.listeners.remove(snacRequestListener);
        }
    }

    public final synchronized boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public final SnacCommand getCommand() {
        return this.command;
    }

    public boolean isStoringResponses() {
        return this.storingResponses;
    }

    public void setStoringResponses(boolean bl) {
        this.storingResponses = bl;
    }

    public final synchronized long getSentTime() {
        return this.sentAt;
    }

    public final synchronized List<SnacResponseEvent> getResponses() {
        List<SnacResponseEvent> list = this.responses;
        if (list == null || list.isEmpty()) {
            return DefensiveTools.emptyList();
        }
        return DefensiveTools.getUnmodifiableCopy(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sent(SnacRequestSentEvent snacRequestSentEvent) {
        boolean bl = logger.logFinerEnabled();
        if (bl) {
            logger.logFiner("Snac request sent: " + this);
        }
        Object object = this;
        synchronized (object) {
            this.sentAt = snacRequestSentEvent.getSentTime();
        }
        object = this.getListenersCopy();
        if (object != null) {
            Object object2 = this.listenerEventLock;
            synchronized (object2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SnacRequestListener snacRequestListener = (SnacRequestListener)iterator.next();
                    if (bl) {
                        logger.logFiner("Running response listener " + snacRequestListener);
                    }
                    try {
                        snacRequestListener.handleSent(snacRequestSentEvent);
                    }
                    catch (Throwable throwable) {
                        snacRequestSentEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.logFiner("Finished processing Snac request send");
        }
    }

    @Nullable
    private synchronized List<SnacRequestListener> getListenersCopy() {
        List<SnacRequestListener> list = this.listeners;
        if (list != null && list.isEmpty()) {
            list = null;
        }
        if (list == null) {
            return null;
        }
        return new ArrayList<SnacRequestListener>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void gotResponse(SnacResponseEvent snacResponseEvent) {
        boolean bl = logger.logFinerEnabled();
        if (bl) {
            logger.logFiner("Processing response " + snacResponseEvent.getSnacPacket() + " to Snac request " + this);
        }
        Object object = this;
        synchronized (object) {
            if (this.storingResponses) {
                if (this.responses == null) {
                    this.responses = new ArrayList<SnacResponseEvent>(5);
                }
                this.responses.add(snacResponseEvent);
            }
        }
        object = this.getListenersCopy();
        if (object != null) {
            Object object2 = this.listenerEventLock;
            synchronized (object2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SnacRequestListener snacRequestListener = (SnacRequestListener)iterator.next();
                    if (bl) {
                        logger.logFiner("Running response listener " + snacRequestListener);
                    }
                    try {
                        snacRequestListener.handleResponse(snacResponseEvent);
                    }
                    catch (Throwable throwable) {
                        snacResponseEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.logFiner("Finished handling response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void timedOut(SnacRequestTimeoutEvent snacRequestTimeoutEvent) {
        List<SnacRequestListener> list;
        boolean bl = logger.logFinerEnabled();
        if (bl) {
            logger.logFiner("Snac request " + this + " timed out");
        }
        if ((list = this.getListenersCopy()) != null) {
            Object object = this.listenerEventLock;
            synchronized (object) {
                for (SnacRequestListener snacRequestListener : list) {
                    if (bl) {
                        logger.logFiner("Running response listener " + snacRequestListener + " for request timeout");
                    }
                    try {
                        snacRequestListener.handleTimeout(snacRequestTimeoutEvent);
                    }
                    catch (Throwable throwable) {
                        snacRequestTimeoutEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.logFiner("Finished handling Snac request timeout");
        }
    }

    public synchronized String toString() {
        return "SnacRequest for " + this.command + ": listeners: " + this.listeners + ", responses: " + this.responses;
    }
}

