/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.trillcrypt;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class TrillianCryptAcceptRvCmd
extends AbstractTrillianCryptRvCmd {
    private static final int TYPE_PUBLICVALUE = 1003;
    private final BigInteger publicValue;

    public TrillianCryptAcceptRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getExtraTlvs();
        Tlv tlv = tlvChain.getLastTlv(1003);
        BigInteger bigInteger = null;
        if (tlv != null) {
            bigInteger = TrillianCryptAcceptRvCmd.getBigIntFromHexBlock(tlv.getData());
        }
        this.publicValue = bigInteger;
    }

    public TrillianCryptAcceptRvCmd(BigInteger bigInteger) {
        super(1);
        this.publicValue = bigInteger;
    }

    public final BigInteger getPublicValue() {
        return this.publicValue;
    }

    protected void writeExtraTlvs(OutputStream outputStream) throws IOException {
        if (this.publicValue != null) {
            byte[] byArray = TrillianCryptAcceptRvCmd.getBigIntHexBlock(this.publicValue);
            new Tlv(1003, ByteBlock.wrap(byArray)).write(outputStream);
        }
    }

    public String toString() {
        return "TrillianEncryptAcceptRvCmd: code=" + this.publicValue;
    }
}

