/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRvCmd;
import net.kano.joscar.rvcmd.RequestRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractRequestRvCmd
extends AbstractRvCmd
implements RequestRvCmd {
    public static final boolean FPRESENT_DEFAULT = true;
    private static final int TYPE_REQINDEX = 10;
    private static final int TYPE_F = 15;
    private final int reqIndex;
    private final boolean fPresent;

    protected AbstractRequestRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.reqIndex = tlvChain.getUShort(10);
        this.fPresent = tlvChain.hasTlv(15);
        this.getMutableTlvs().removeTlvs(10, 15);
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock) {
        this(capabilityBlock, 1);
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock, int n) {
        this(capabilityBlock, n, true);
    }

    protected AbstractRequestRvCmd(CapabilityBlock capabilityBlock, int n, boolean bl) {
        super(0, capabilityBlock);
        DefensiveTools.checkRange(n, "requestIndex", -1);
        this.reqIndex = n;
        this.fPresent = bl;
    }

    public boolean isFirstRequest() {
        return this.getRequestIndex() == 1;
    }

    public final int getRequestIndex() {
        return this.reqIndex;
    }

    protected final boolean isFPresent() {
        return this.fPresent;
    }

    protected final void writeHeaderRvTlvs(OutputStream outputStream) throws IOException {
        if (this.reqIndex != -1) {
            Tlv.getUShortInstance(10, this.reqIndex).write(outputStream);
        }
        if (this.fPresent) {
            new Tlv(15).write(outputStream);
        }
    }
}

