/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rv;

import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.icbm.RvCommand;

public class RecvRvEvent
extends SnacPacketEvent {
    public static final String TYPE_RV = "TYPE_RV";
    public static final String TYPE_RESPONSE = "TYPE_RESPONSE";
    private final String type;
    private final RvProcessor rvProcessor;
    private final RvSession rvSession;
    private final RvCommand rvCommand;
    private final int responseCode;

    protected RecvRvEvent(SnacPacketEvent snacPacketEvent, RvProcessor rvProcessor, RvSession rvSession, RvCommand rvCommand) {
        this(TYPE_RV, snacPacketEvent, rvProcessor, rvSession, rvCommand, -1);
    }

    protected RecvRvEvent(SnacPacketEvent snacPacketEvent, RvProcessor rvProcessor, RvSession rvSession, int n) {
        this(TYPE_RV, snacPacketEvent, rvProcessor, rvSession, null, n);
        DefensiveTools.checkRange(n, "resultCode", -1);
    }

    private RecvRvEvent(String string, SnacPacketEvent snacPacketEvent, RvProcessor rvProcessor, RvSession rvSession, RvCommand rvCommand, int n) {
        super(snacPacketEvent);
        DefensiveTools.checkNull(string, "type");
        DefensiveTools.checkNull(rvProcessor, "rvProcessor");
        DefensiveTools.checkNull(rvSession, "rvSession");
        if (string != TYPE_RV && string != TYPE_RESPONSE) {
            throw new IllegalArgumentException("type (" + string + ") must be " + "one of TYPE_RV and TYPE_RESPONSE");
        }
        if (rvCommand != null && n != -1) {
            throw new IllegalArgumentException("only one of rvCommand and responseCode can have a non-null or nonnegative value");
        }
        this.type = string;
        this.rvProcessor = rvProcessor;
        this.rvSession = rvSession;
        this.rvCommand = rvCommand;
        this.responseCode = n;
    }

    public final String getRvEventType() {
        return this.type;
    }

    public final RvProcessor getRvProcessor() {
        return this.rvProcessor;
    }

    public final RvSession getRvSession() {
        return this.rvSession;
    }

    public final RvCommand getRvCommand() {
        return this.rvCommand;
    }

    public final int getRvResponseCode() {
        return this.responseCode;
    }

    public String toString() {
        return "RecvRvEvent for " + this.rvSession.getScreenname() + ": " + (this.type == TYPE_RV ? "rvCommand=" + this.rvCommand : "rvResponseCode=" + this.responseCode);
    }
}

