/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.tlv.DefaultMutableTlvChain;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TlvTools {
    private TlvTools() {
    }

    public static ImmutableTlvChain readChain(ByteBlock byteBlock) {
        return TlvTools.readChain(byteBlock, -1);
    }

    public static ImmutableTlvChain readChain(ByteBlock byteBlock, int n) {
        return new ImmutableTlvChain(byteBlock, n);
    }

    public static ImmutableTlvChain createChain(List<Tlv> list, int n, int n2) {
        DefensiveTools.checkNull(list, "tlvs");
        if (n < 0 || n2 < 0 || n + n2 > list.size()) {
            throw new ArrayIndexOutOfBoundsException("offset=" + n + ", len=" + n2 + ", tlvs.length=" + list.size());
        }
        DefensiveTools.checkNullElements(list, "tlvs", n, n2);
        return new ImmutableTlvChain(list, n, n2);
    }

    public static MutableTlvChain createMutableChain() {
        return new DefaultMutableTlvChain();
    }

    public static MutableTlvChain getMutableCopy(TlvChain tlvChain) {
        return new DefaultMutableTlvChain(tlvChain);
    }

    public static ImmutableTlvChain getImmutableCopy(TlvChain tlvChain) {
        return new ImmutableTlvChain(tlvChain);
    }

    public static boolean isCompleteTlvChain(ByteBlock byteBlock) {
        int n = byteBlock.getLength();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (n2 + 3 >= n) {
                return false;
            }
            if ((n2 += 2 + (n3 = BinaryTools.getUShort(byteBlock, n2 + 2))) == n) {
                return true;
            }
            if (n2 <= n) continue;
            return false;
        }
        throw new IllegalStateException();
    }
}

