/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class SsiDataModResponse
extends SsiCommand {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_NO_SUCH_ITEM = 2;
    public static final int RESULT_CANT_ADD_ANOTHER_ROOT_GROUP = 3;
    public static final int RESULT_ID_TAKEN = 10;
    public static final int RESULT_MAX_ITEMS = 12;
    public static final int RESULT_NO_ICQ = 13;
    public static final int RESULT_ICQ_AUTH_REQUIRED = 14;
    public static final int RESULT_BAD_FORMAT = 16;
    private final int[] results;

    protected SsiDataModResponse(SnacPacket snacPacket) {
        super(14);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        int n = byteBlock.getLength() / 2;
        this.results = new int[n];
        for (int i = 0; i < n; ++i) {
            this.results[i] = BinaryTools.getUShort(byteBlock, i * 2);
        }
    }

    public SsiDataModResponse(int[] nArray) {
        super(14);
        this.results = DefensiveTools.getSafeMinArrayCopy(nArray, "results", 0);
    }

    public final int[] getResults() {
        return (int[])this.results.clone();
    }

    public void writeData(OutputStream outputStream) throws IOException {
        for (int n : this.results) {
            BinaryTools.writeUShort(outputStream, n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SsiDataModAck: results=");
        for (int i = 0; i < this.results.length; ++i) {
            int n = this.results[i];
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(n));
            String string = MiscTools.findIntField(SsiDataModResponse.class, n, "RESULT_.*");
            if (string != null) {
                stringBuffer.append(" (");
                stringBuffer.append(string);
                stringBuffer.append(")");
            }
            if (i == this.results.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

