/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemsCmd
extends SsiCommand {
    private final List<SsiItem> items;

    protected ItemsCmd(int n, SnacPacket snacPacket) {
        super(n);
        SsiItem ssiItem;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ArrayList<SsiItem> arrayList = new ArrayList<SsiItem>();
        while ((ssiItem = SsiItem.readSsiItem(byteBlock)) != null) {
            arrayList.add(ssiItem);
            byteBlock = byteBlock.subBlock(ssiItem.getTotalSize());
        }
        this.items = DefensiveTools.getUnmodifiable(arrayList);
    }

    protected ItemsCmd(int n, Collection<? extends SsiItem> collection) {
        super(n);
        this.items = DefensiveTools.getSafeNonnullListCopy(collection, "items");
    }

    public final List<SsiItem> getItems() {
        return this.items;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        for (SsiItem ssiItem : this.items) {
            ssiItem.write(outputStream);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": " + this.items.size() + " items: " + this.items;
    }
}

