/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.ft;

import java.util.zip.Checksum;
import net.kano.joscar.DefensiveTools;

public final class FileTransferChecksum
implements Checksum {
    public static final long CHECKSUM_EMPTY = 0xFFFF0000L;
    private long checksum;

    public FileTransferChecksum() {
        this.reset();
    }

    public void update(int n) {
        this.update(new byte[]{(byte)n}, 0, 1);
    }

    public void update(byte[] byArray, int n, int n2) {
        DefensiveTools.checkNull(byArray, "input");
        assert (this.checksum >= 0L);
        long l = this.checksum >> 16 & 0xFFFFL;
        for (int i = 0; i < n2; ++i) {
            long l2 = l;
            int n3 = byArray[n + i] & 0xFF;
            int n4 = (i & 1) != 0 ? n3 : n3 << 8;
            if ((l -= (long)n4) <= l2) continue;
            --l;
        }
        l = (l & 0xFFFFL) + (l >> 16);
        l = (l & 0xFFFFL) + (l >> 16);
        this.checksum = l << 16 & 0xFFFFFFFFL;
        assert (this.checksum >= 0L);
    }

    public long getValue() {
        assert (this.checksum >= 0L);
        return this.checksum;
    }

    public void reset() {
        this.checksum = 0xFFFF0000L;
        assert (this.checksum >= 0L);
    }

    public String toString() {
        return "FileTransferChecksum: " + this.checksum;
    }
}

