/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.kano.joscar.DefensiveTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SegmentedFilename {
    private static final String FILESEP_FT = "\u0001";
    public static final String FILESEP_NATIVE = File.separator;
    private final List<String> parts;

    public SegmentedFilename(String ... stringArray) {
        this(Arrays.asList(stringArray));
    }

    private static SegmentedFilename createFromString(String string, String string2) {
        DefensiveTools.checkNull(string, "path");
        DefensiveTools.checkNull(string2, "separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            linkedList.add(string3);
        }
        return new SegmentedFilename(linkedList);
    }

    public static SegmentedFilename fromNativeFilename(String string) {
        return SegmentedFilename.createFromString(string, FILESEP_NATIVE);
    }

    public static SegmentedFilename fromFTFilename(String string) {
        return SegmentedFilename.createFromString(string, FILESEP_FT);
    }

    public SegmentedFilename(SegmentedFilename segmentedFilename, String string) {
        this(segmentedFilename, new SegmentedFilename(Arrays.asList(string)));
    }

    public SegmentedFilename(SegmentedFilename segmentedFilename, SegmentedFilename segmentedFilename2) {
        DefensiveTools.checkNull(segmentedFilename2, "file");
        if (segmentedFilename == null) {
            this.parts = segmentedFilename2.parts;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(segmentedFilename.parts.size() + segmentedFilename2.parts.size());
            arrayList.addAll(segmentedFilename.parts);
            arrayList.addAll(segmentedFilename2.parts);
            this.parts = DefensiveTools.getUnmodifiable(arrayList);
        }
    }

    public SegmentedFilename(Collection<String> collection) {
        this.parts = DefensiveTools.getSafeNonnullListCopy(collection, "parts");
    }

    public final List<String> getSegments() {
        return this.parts;
    }

    public final String getLastSegment() {
        return this.parts.isEmpty() ? null : this.parts.get(0);
    }

    private String toFilename(String string) {
        DefensiveTools.checkNull(string, "sep");
        StringBuffer stringBuffer = new StringBuffer(this.parts.size() * 16);
        boolean bl = true;
        for (String string2 : this.parts) {
            if (string2.length() == 0) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public final String toNativeFilename() {
        return this.toFilename(FILESEP_NATIVE);
    }

    public final String toFTFilename() {
        return this.toFilename(FILESEP_FT);
    }

    public int hashCode() {
        int n = 0;
        for (String string : this.parts) {
            n += 29 * string.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SegmentedFilename)) {
            return false;
        }
        return ((Object)this.parts).equals(((SegmentedFilename)object).parts);
    }

    public String toString() {
        return "SegmentedFilename: " + this.parts + " (" + this.toNativeFilename() + ")";
    }
}

