/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.secureim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.MinimalEncoder;
import net.kano.joustsim.oscar.oscar.NoBuddyKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.NoLocalKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimCodec;
import net.kano.joustsim.trust.CertificatePairHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class SecureAimEncoder
extends SecureAimCodec {
    public synchronized byte[] encryptMsg(String msg) throws NoSuchProviderException, NoSuchAlgorithmException, CMSException, IOException, NoBuddyKeysException, NoLocalKeysException {
        if (this.getLocalKeys() == null) {
            throw new NoLocalKeysException();
        }
        CertificatePairHolder buddyCerts = this.getBuddyCerts();
        if (buddyCerts == null) {
            throw new NoBuddyKeysException();
        }
        X509Certificate recip = buddyCerts.getSigningCertificate();
        if (recip == null) {
            throw new NoBuddyKeysException();
        }
        byte[] signedDataBlock = this.cmsSignString(msg);
        CMSEnvelopedDataGenerator gen = new CMSEnvelopedDataGenerator();
        gen.addKeyTransRecipient(recip);
        CMSEnvelopedData envData = gen.generate((CMSProcessable)new CMSProcessableByteArray(signedDataBlock), "2.16.840.1.101.3.4.1.2", "BC");
        return envData.getEncoded();
    }

    protected synchronized byte[] cmsSignString(String msg) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, CMSException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bout, "US-ASCII");
        EncodedStringInfo encodeInfo = MinimalEncoder.encodeMinimally((String)msg);
        String charset = encodeInfo.getCharset().toLowerCase();
        osw.write("Content-Transfer-Encoding: binary\r\nContent-Type: text/x-aolrtf; charset=" + charset + "\r\n" + "Content-Language: en\r\n" + "\r\n");
        osw.flush();
        bout.write(encodeInfo.getData());
        byte[] dataToSign = bout.toByteArray();
        byte[] signedData = this.signData(dataToSign);
        bout = new ByteArrayOutputStream();
        osw = new OutputStreamWriter((OutputStream)bout, "US-ASCII");
        osw.write("Content-Transfer-Encoding: binary\r\nContent-Type: application/pkcs7-mime; charset=us-ascii\r\nContent-Language: en\r\n\r\n");
        osw.flush();
        bout.write(signedData);
        return bout.toByteArray();
    }

    protected synchronized byte[] signData(byte[] dataToSign) throws NoSuchProviderException, NoSuchAlgorithmException, CMSException, IOException {
        CMSSignedDataGenerator sgen = new CMSSignedDataGenerator();
        sgen.addSigner((PrivateKey)this.getLocalKeys().getSigningKeys().getPrivateKey(), this.getLocalKeys().getSigningCertificate(), "1.2.840.113549.2.5");
        CMSSignedData csd = sgen.generate((CMSProcessable)new CMSProcessableByteArray(dataToSign), true, "BC");
        byte[] signedData = csd.getEncoded();
        return signedData;
    }
}

