/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.rv.NewRvSessionEvent;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvCommandFactory;
import net.kano.joscar.rv.RvProcessor;
import net.kano.joscar.rv.RvProcessorListener;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSessionListener;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.rvcmd.DefaultRvCommandFactory;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.MissedMessagesCmd;
import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;
import net.kano.joscar.snaccmd.icbm.ParamInfo;
import net.kano.joscar.snaccmd.icbm.ParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.ParamInfoRequest;
import net.kano.joscar.snaccmd.icbm.RecvImIcbm;
import net.kano.joscar.snaccmd.icbm.RecvTypingNotification;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.snaccmd.icbm.SendImIcbm;
import net.kano.joscar.snaccmd.icbm.SendTypingNotification;
import net.kano.joscar.snaccmd.icbm.SetParamInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.CapabilityHandler;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.DirectimConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ImConversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ImMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.MissedImInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousCapabilityHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManager;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManagerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.InternalSecureTools;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimConversation;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IcbmService
extends Service {
    private static final Logger LOGGER = Logger.getLogger(IcbmService.class.getName());
    private RvProcessor rvProcessor;
    private RvConnectionManager rvConnectionManager;
    private CopyOnWriteArrayList<IcbmListener> listeners = new CopyOnWriteArrayList();
    private final BuddyInfoManager buddyInfoManager;
    private Map<Screenname, SecureAimConversation> secureAimConvs = new HashMap<Screenname, SecureAimConversation>();
    private Map<Screenname, DirectimConversation> directimconvs = new HashMap<Screenname, DirectimConversation>();
    private Map<Screenname, ImConversation> imconvs = new HashMap<Screenname, ImConversation>();

    public IcbmService(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 4);
        this.rvProcessor = new RvProcessor(oscarConnection.getSnacProcessor());
        this.rvProcessor.registerRvCmdFactory((RvCommandFactory)new DefaultRvCommandFactory());
        this.rvProcessor.addListener((RvProcessorListener)new DelegatingRvProcessorListener());
        this.rvConnectionManager = new RvConnectionManager(this);
        this.buddyInfoManager = this.getAimConnection().getBuddyInfoManager();
        this.rvConnectionManager.addConnectionManagerListener(new RvConnectionManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleNewIncomingConnection(RvConnectionManager manager, IncomingRvConnection connection) {
                if (connection instanceof DirectimConnection) {
                    DirectimConnection dim = (DirectimConnection)((Object)connection);
                    DirectimConversation conv = new DirectimConversation(IcbmService.this.getAimConnection(), dim);
                    IcbmService icbmService = IcbmService.this;
                    synchronized (icbmService) {
                        IcbmService.this.directimconvs.put(dim.getBuddyScreenname(), conv);
                    }
                    IcbmService.this.initConversation(conv);
                }
            }
        });
    }

    public RvConnectionManager getRvConnectionManager() {
        return this.rvConnectionManager;
    }

    public void addIcbmListener(IcbmListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeIcbmListener(IcbmListener l) {
        this.listeners.remove((Object)l);
    }

    public SnacFamilyInfo getSnacFamilyInfo() {
        return IcbmCommand.FAMILY_INFO;
    }

    public void connected() {
        this.sendSnac((SnacCommand)new ParamInfoRequest());
    }

    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        if (snac instanceof ParamInfoCmd) {
            ParamInfoCmd pic = (ParamInfoCmd)snac;
            this.handleParamInfo(pic);
        } else if (snac instanceof RecvImIcbm) {
            RecvImIcbm icbm = (RecvImIcbm)snac;
            this.handleImIcbm(icbm);
        } else if (snac instanceof MissedMessagesCmd) {
            MissedMessagesCmd mc = (MissedMessagesCmd)snac;
            this.handleMissedMessages(mc);
        } else if (snac instanceof RecvTypingNotification) {
            RecvTypingNotification typnot = (RecvTypingNotification)snac;
            this.handleTypingNotification(typnot);
        }
    }

    public RvProcessor getRvProcessor() {
        return this.rvProcessor;
    }

    private void handleParamInfo(ParamInfoCmd pic) {
        ParamInfo pi = pic.getParamInfo();
        long newflags = pi.getFlags() | 1L | 2L | 8L;
        ParamInfo newparams = new ParamInfo(newflags, 8000, WarningLevel.getInstanceFromX10((int)999), WarningLevel.getInstanceFromX10((int)999), 0L);
        this.sendSnac((SnacCommand)new SetParamInfoCmd(newparams));
        this.setReady();
    }

    private void handleMissedMessages(MissedMessagesCmd mc) {
        List msgs = mc.getMissedMsgInfos();
        for (MissedMsgInfo msg : msgs) {
            Screenname sn = new Screenname(msg.getUserInfo().getScreenname());
            ImConversation conv = this.getImConversation(sn);
            conv.handleMissedMsg(MissedImInfo.getInstance(this.getScreenname(), msg));
        }
    }

    private void handleImIcbm(RecvImIcbm icbm) {
        FullUserInfo senderInfo = icbm.getSenderInfo();
        if (senderInfo == null) {
            return;
        }
        Screenname sender = new Screenname(senderInfo.getScreenname());
        InstantMessage message = icbm.getMessage();
        if (message == null) {
            return;
        }
        if (message.isEncrypted()) {
            SecureAimConversation conv = this.getSecureAimConversation(sender);
            EncryptedAimMessage msg = InternalSecureTools.getEncryptedAimMessageInstance(icbm);
            if (msg == null) {
                return;
            }
            BuddyInfo info = this.buddyInfoManager.getBuddyInfo(sender);
            BuddyCertificateInfo certInfo = info.getCertificateInfo();
            EncryptedAimMessageInfo minfo = EncryptedAimMessageInfo.getInstance(this.getScreenname(), icbm, certInfo, new Date());
            if (minfo == null) {
                return;
            }
            ((Conversation)conv).handleIncomingEvent(minfo);
        } else {
            ImConversation conv = this.getImConversation(sender);
            ImMessageInfo msg = ImMessageInfo.getInstance(this.getScreenname(), icbm, new Date());
            conv.handleIncomingEvent(msg);
        }
    }

    private void handleTypingNotification(RecvTypingNotification typnot) {
        Screenname sender = new Screenname(typnot.getScreenname());
        ImConversation conv = this.getImConversation(sender);
        TypingState typingState = this.getTypingState(typnot.getTypingState());
        if (typingState != null) {
            ((Conversation)conv).handleIncomingEvent(new TypingInfo(sender, this.getScreenname(), new Date(), typingState));
        }
    }

    @Nullable
    private TypingState getTypingState(int typingState) {
        if (typingState == 2) {
            return TypingState.TYPING;
        }
        if (typingState == 0) {
            return TypingState.NO_TEXT;
        }
        if (typingState == 1) {
            return TypingState.PAUSED;
        }
        LOGGER.log(Level.WARNING, "Unknown typing state " + typingState);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureAimConversation getSecureAimConversation(Screenname sn) {
        SecureAimConversation conv;
        boolean isnew = false;
        IcbmService icbmService = this;
        synchronized (icbmService) {
            conv = this.secureAimConvs.get(sn);
            if (conv == null) {
                isnew = true;
                conv = InternalSecureTools.newSecureAimConversation(this.getAimConnection(), sn);
                this.secureAimConvs.put(sn, conv);
            }
        }
        if (isnew) {
            this.initConversation(conv);
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectimConversation getDirectimConversation(Screenname sn) {
        DirectimConversation conv;
        boolean isnew = false;
        IcbmService icbmService = this;
        synchronized (icbmService) {
            conv = this.directimconvs.get(sn);
            if (conv == null || conv.isClosed()) {
                isnew = true;
                conv = new DirectimConversation(this.getAimConnection(), sn);
                this.directimconvs.put(sn, conv);
            }
        }
        if (isnew) {
            this.initConversation(conv);
        }
        return conv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImConversation getImConversation(Screenname sn) {
        ImConversation conv;
        boolean isnew = false;
        IcbmService icbmService = this;
        synchronized (icbmService) {
            conv = this.imconvs.get(sn);
            if (conv == null) {
                isnew = true;
                conv = new ImConversation(this.getAimConnection(), sn);
                this.imconvs.put(sn, conv);
            }
        }
        if (isnew) {
            this.initConversation(conv);
        }
        return conv;
    }

    private void initConversation(Conversation conv) {
        assert (!Thread.holdsLock(this));
        conv.initialize();
        for (IcbmListener listener : this.listeners) {
            listener.newConversation(this, conv);
        }
    }

    void sendIM(Screenname buddy, String body, boolean autoresponse) {
        this.sendIM(buddy, new InstantMessage(body), autoresponse);
    }

    void sendIM(Screenname buddy, InstantMessage im, boolean autoresponse) {
        this.sendSnac((SnacCommand)new SendImIcbm(buddy.getFormatted(), im, autoresponse, 0L, false, null, null, !autoresponse));
    }

    void sendTypingStatus(Screenname buddy, TypingState typingState) {
        DefensiveTools.checkNull((Object)((Object)typingState), (String)"typingState");
        this.sendSnac((SnacCommand)new SendTypingNotification(buddy.getFormatted(), this.getTypingStateCode(typingState)));
    }

    private int getTypingStateCode(@NotNull TypingState typingState) {
        if (typingState == TypingState.TYPING) {
            return 2;
        }
        if (typingState == TypingState.PAUSED) {
            return 1;
        }
        if (typingState == TypingState.NO_TEXT) {
            return 0;
        }
        throw new IllegalArgumentException("no code for typing state " + (Object)((Object)typingState));
    }

    private class SessionListenerDelegate
    implements RvSessionListener {
        private RendezvousSessionHandler sessionHandler;
        private final RvSession session;

        public SessionListenerDelegate(RvSession session) {
            this.session = session;
            this.sessionHandler = null;
        }

        public void handleRv(RecvRvEvent event) {
            if (this.sessionHandler == null) {
                RvCommand rvCommand = event.getRvCommand();
                if (rvCommand == null) {
                    LOGGER.warning("unknown rv command: " + event.getSnacCommand());
                    return;
                }
                CapabilityBlock cap = rvCommand.getCapabilityBlock();
                CapabilityHandler handler = IcbmService.this.getAimConnection().getCapabilityManager().getCapabilityHandler(cap);
                if (handler instanceof RendezvousCapabilityHandler) {
                    RendezvousCapabilityHandler rhandler = (RendezvousCapabilityHandler)handler;
                    RendezvousSessionHandler sessionHandler = rhandler.handleSession(IcbmService.this, this.session);
                    if (sessionHandler == null) {
                        throw new IllegalStateException("RendezvousCapabilityHandler " + rhandler + " did not return session handler for " + this.session);
                    }
                    this.sessionHandler = sessionHandler;
                } else {
                    LOGGER.warning("Rendezvous for " + cap + " ignored because the handler, " + handler + ", does not support rendezvous");
                    this.session.removeListener((RvSessionListener)this);
                    return;
                }
            }
            this.sessionHandler.handleRv(event);
        }

        public void handleSnacResponse(RvSnacResponseEvent event) {
            if (this.sessionHandler == null) {
                LOGGER.warning("Got SNAC response in RV processor listener, but no handler has been registered yet: " + event);
            } else {
                this.sessionHandler.handleSnacResponse(event);
            }
        }
    }

    private class DelegatingRvProcessorListener
    implements RvProcessorListener {
        private DelegatingRvProcessorListener() {
        }

        public void handleNewSession(NewRvSessionEvent event) {
            if (event.getSessionType() == NewRvSessionEvent.TYPE_INCOMING) {
                RvSession session = event.getSession();
                session.addListener((RvSessionListener)new SessionListenerDelegate(session));
            }
        }
    }
}

