/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.io.DataInputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPPacketParser;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.UDPPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.util.Logger;

public class RTCPPacketParserEx
extends RTCPPacketParser {
    private static final Logger logger = Logger.getLogger(RTCPPacketParserEx.class);

    public RTCPPacket parse(byte[] data, int offset, int length) throws BadFormatException {
        UDPPacket udp = new UDPPacket();
        udp.data = data;
        udp.length = length;
        udp.offset = offset;
        udp.received = false;
        return this.parse(udp);
    }

    @Override
    protected RTCPPacket parse(RTCPCompoundPacket base, int firstbyte, int type, int length, DataInputStream in) throws BadFormatException, IOException {
        if (type == 205 || type == 206) {
            long senderSSRC = (long)in.readInt() & 0xFFFFFFFFL;
            long sourceSSRC = (long)in.readInt() & 0xFFFFFFFFL;
            if (type == 205) {
                return this.parseRTCPFBPacket(base, firstbyte, 205, length, in, senderSSRC, sourceSSRC);
            }
            switch (firstbyte) {
                case 15: {
                    RTCPREMBPacket remb = new RTCPREMBPacket(base);
                    remb.senderSSRC = senderSSRC;
                    remb.sourceSSRC = sourceSSRC;
                    in.readInt();
                    int destlen = in.readUnsignedByte();
                    byte[] buf = new byte[3];
                    in.read(buf);
                    remb.exp = (buf[0] & 0xFC) >> 2;
                    remb.mantissa = (buf[0] & 3) << 16 & 0xFF0000 | buf[1] << 8 & 0xFF00 | buf[2] & 0xFF;
                    remb.dest = new long[destlen];
                    for (int i = 0; i < remb.dest.length; ++i) {
                        remb.dest[i] = (long)in.readInt() & 0xFFFFFFFFL;
                    }
                    return remb;
                }
            }
            return this.parseRTCPFBPacket(base, firstbyte, 206, length, in, senderSSRC, sourceSSRC);
        }
        return null;
    }

    private RTCPFBPacket parseRTCPFBPacket(RTCPCompoundPacket base, int firstbyte, int type, int length, DataInputStream in, long senderSSRC, long sourceSSRC) throws IOException {
        RTCPFBPacket fb = new RTCPFBPacket(base);
        fb.fmt = firstbyte;
        fb.type = type;
        fb.senderSSRC = senderSSRC;
        fb.sourceSSRC = sourceSSRC;
        int fcilen = length - 12;
        if (fcilen != 0) {
            fb.fci = new byte[fcilen];
            in.read(fb.fci);
        }
        if (logger.isTraceEnabled()) {
            String ptStr;
            String fmtStr = null;
            String detailStr = null;
            switch (fb.type) {
                case 206: {
                    ptStr = "PSFB";
                    switch (fb.fmt) {
                        case 4: {
                            fmtStr = "FIR";
                            break;
                        }
                        case 1: {
                            fmtStr = "PLI";
                            break;
                        }
                        case 15: {
                            fmtStr = "REMB";
                        }
                    }
                    break;
                }
                case 205: {
                    ptStr = "RTPFB";
                    switch (fb.fmt) {
                        case 1: {
                            fmtStr = "Generic NACK";
                            break;
                        }
                        case 3: {
                            fmtStr = "TMMBR";
                            break;
                        }
                        case 4: {
                            fmtStr = "TMMBN";
                            StringBuilder tmmbnFciEntryStr = new StringBuilder();
                            int end = fcilen - 8;
                            for (int i = 0; i < end; i += 8) {
                                int ssrc = RTPTranslatorImpl.readInt(fb.fci, i);
                                byte b4 = fb.fci[i + 4];
                                int mxTbrExp = (b4 & 0xFC) >>> 2;
                                byte b6 = fb.fci[i + 6];
                                int mxTbrMantissa = (b4 & 1) << 16 & 0xFF0000 | fb.fci[i + 5] << 8 & 0xFF00 | b6 & 0xFF;
                                int measuredOverhead = (b6 & 1) << 8 & 0xFF00 | fb.fci[i + 7] & 0xFF;
                                tmmbnFciEntryStr.append(", SSRC 0x");
                                tmmbnFciEntryStr.append(Long.toHexString((long)ssrc & 0xFFFFFFFFL));
                                tmmbnFciEntryStr.append(", MxTBR Exp ");
                                tmmbnFciEntryStr.append(mxTbrExp);
                                tmmbnFciEntryStr.append(", MxTBR Mantissa ");
                                tmmbnFciEntryStr.append(mxTbrMantissa);
                                tmmbnFciEntryStr.append(", Measured Overhead ");
                                tmmbnFciEntryStr.append(measuredOverhead);
                            }
                            detailStr = tmmbnFciEntryStr.toString();
                        }
                    }
                    break;
                }
                default: {
                    ptStr = Integer.toString(fb.type);
                }
            }
            if (fmtStr == null) {
                fmtStr = Integer.toString(fb.fmt);
            }
            if (detailStr == null) {
                detailStr = "";
            }
            logger.trace("SSRC of packet sender: 0x" + Long.toHexString(senderSSRC) + " (" + senderSSRC + "), SSRC of media source: 0x" + Long.toHexString(sourceSSRC) + " (" + sourceSSRC + "), Payload type (PT): " + ptStr + ", Feedback message type (FMT): " + fmtStr + detailStr);
        }
        return fb;
    }
}

