/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.osgi.OSGi;
import org.jitsi.jicofo.xmpp.FocusComponent;
import org.jitsi.util.StringUtils;
import org.jivesoftware.whack.ExternalComponentManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;

public class Main {
    private static final Logger logger = Logger.getLogger(Main.class);
    private static final String DOMAIN_ARG_NAME = "--domain=";
    private static final Object exitSynRoot = new Object();
    private static final String USER_DOMAIN_ARG_NAME = "--user_domain=";
    private static final String USER_NAME_ARG_NAME = "--user_name=";
    private static final String USER_NAME_ARG_VALUE = "focus";
    private static final String USER_PASSWORD_ARG_NAME = "--user_password=";
    private static final String HOST_ARG_NAME = "--host=";
    private static final String HOST_ARG_VALUE = "localhost";
    private static final String PORT_ARG_NAME = "--port=";
    private static final int PORT_ARG_VALUE = 5347;
    private static final String SECRET_ARG_NAME = "--secret=";
    private static final String SUBDOMAIN_ARG_NAME = "--subdomain=";
    private static final String SUBDOMAIN_ARG_VALUE = "focus";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String host = HOST_ARG_VALUE;
        String componentDomain = null;
        String focusDomain = null;
        String focusUserName = null;
        String focusPassword = null;
        String componentSubDomain = "focus";
        int port = 5347;
        String secret = null;
        for (String arg : args) {
            if (arg.startsWith(DOMAIN_ARG_NAME)) {
                componentDomain = arg.substring(DOMAIN_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(HOST_ARG_NAME)) {
                host = arg.substring(HOST_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(USER_DOMAIN_ARG_NAME)) {
                focusDomain = arg.substring(USER_DOMAIN_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(USER_NAME_ARG_NAME)) {
                focusUserName = arg.substring(USER_NAME_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(USER_PASSWORD_ARG_NAME)) {
                focusPassword = arg.substring(USER_PASSWORD_ARG_NAME.length());
                continue;
            }
            if (arg.startsWith(PORT_ARG_NAME)) {
                port = Integer.parseInt(arg.substring(PORT_ARG_NAME.length()));
                continue;
            }
            if (arg.startsWith(SECRET_ARG_NAME)) {
                secret = arg.substring(SECRET_ARG_NAME.length());
                continue;
            }
            if (!arg.startsWith(SUBDOMAIN_ARG_NAME)) continue;
            componentSubDomain = arg.substring(SUBDOMAIN_ARG_NAME.length());
        }
        if (StringUtils.isNullOrEmpty((String)host)) {
            String string = host = componentDomain == null ? HOST_ARG_VALUE : componentDomain;
        }
        if (StringUtils.isNullOrEmpty(componentDomain)) {
            componentDomain = host;
        }
        if (StringUtils.isNullOrEmpty(focusDomain)) {
            focusDomain = componentDomain;
        }
        if (StringUtils.isNullOrEmpty(focusUserName)) {
            focusUserName = "focus";
        }
        if (secret == null) {
            System.err.println("Missing required argument --secret=");
            return;
        }
        System.setProperty("net.java.sip.communicator.service.gui.ALWAYS_TRUST_MODE_ENABLED", "true");
        System.setProperty("org.jitsi.jicofo.HOSTNAME", host);
        System.setProperty("org.jitsi.jicofo.XMPP_DOMAIN", componentDomain);
        System.setProperty("org.jitsi.jicofo.FOCUS_USER_DOMAIN", focusDomain);
        System.setProperty("org.jitsi.jicofo.FOCUS_USER_NAME", focusUserName);
        System.setProperty("org.jitsi.jicofo.FOCUS_USER_PASSWORD", focusPassword);
        BundleActivator activator = new BundleActivator(){

            public void start(BundleContext bundleContext) throws Exception {
                Main.registerShutdownService(bundleContext);
            }

            public void stop(BundleContext bundleContext) throws Exception {
            }
        };
        OSGi.start(activator);
        ExternalComponentManager componentManager = new ExternalComponentManager(host, port);
        componentManager.setSecretKey(componentSubDomain, secret);
        componentManager.setServerName(componentDomain);
        boolean focusAnonymous = StringUtils.isNullOrEmpty((String)focusPassword);
        FocusComponent component = new FocusComponent(focusAnonymous);
        boolean stop = false;
        try {
            componentManager.addComponent(componentSubDomain, (Component)component);
        }
        catch (ComponentException e) {
            logger.error((Object)e, (Throwable)e);
            stop = true;
        }
        component.init();
        if (!stop) {
            try {
                Object e = exitSynRoot;
                synchronized (e) {
                    Main.startQKeyHandler();
                    exitSynRoot.wait();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        component.shutdown();
        try {
            componentManager.removeComponent(componentSubDomain);
        }
        catch (ComponentException e) {
            logger.error((Object)e, (Throwable)e);
        }
        component.dispose();
        OSGi.stop();
    }

    private static void startQKeyHandler() {
        Thread handler = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (System.in.read() != 113) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                Object object = exitSynRoot;
                synchronized (object) {
                    exitSynRoot.notifyAll();
                }
            }
        }, "q-key-handler");
        handler.setDaemon(true);
        handler.start();
    }

    private static void registerShutdownService(BundleContext context) {
        context.registerService(ShutdownService.class, (Object)new ShutdownService(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void beginShutdown() {
                Object object = exitSynRoot;
                synchronized (object) {
                    exitSynRoot.notifyAll();
                }
            }
        }, null);
    }
}

