/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import org.jitsi.jicofo.xmpp.ConferenceIq;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.xmlpull.v1.XmlPullParser;

public class ConferenceIqProvider
implements IQProvider {
    public ConferenceIqProvider() {
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("conference", "http://jitsi.org/protocol/focus", (Object)this);
    }

    public IQ parseIQ(XmlPullParser parser) throws Exception {
        ConferenceIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/focus".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("conference".equals(rootElement)) {
            iq = new ConferenceIq();
            String room = parser.getAttributeValue("", "room");
            iq.setRoom(room);
            String ready = parser.getAttributeValue("", "ready");
            if (!StringUtils.isNullOrEmpty((String)ready)) {
                iq.setReady(Boolean.valueOf(ready));
            }
        } else {
            return null;
        }
        ConferenceIq.Property property = null;
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case 3: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"property".equals(name) || property == null) break;
                    iq.addProperty(property);
                    property = null;
                    break;
                }
                case 2: {
                    String propValue;
                    String name = parser.getName();
                    if (!"property".equals(name)) break;
                    property = new ConferenceIq.Property();
                    String propName = parser.getAttributeValue("", "name");
                    if (!StringUtils.isNullOrEmpty((String)propName)) {
                        property.setName(propName);
                    }
                    if (StringUtils.isNullOrEmpty((String)(propValue = parser.getAttributeValue("", "value")))) break;
                    property.setValue(propValue);
                }
            }
        }
        return iq;
    }
}

