/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConferenceIq
extends IQ {
    public static final String NAMESPACE = "http://jitsi.org/protocol/focus";
    public static final String ELEMENT_NAME = "conference";
    public static final String ROOM_ATTR_NAME = "room";
    public static final String READY_ATTR_NAME = "ready";
    private String room;
    private Boolean ready;
    private List<Property> properties = new ArrayList<Property>();

    void printAttributes(StringBuilder out) {
        out.append(ROOM_ATTR_NAME).append("=").append("'").append(this.room).append("' ");
        if (this.ready != null) {
            out.append(READY_ATTR_NAME).append("=").append("'").append(this.ready).append("' ");
        }
    }

    public String getChildElementXML() {
        StringBuilder xml = new StringBuilder();
        xml.append('<').append(ELEMENT_NAME);
        xml.append(" xmlns='").append(NAMESPACE).append("' ");
        this.printAttributes(xml);
        Collection extensions = this.getExtensions();
        if (extensions.size() > 0 || this.properties.size() > 0) {
            xml.append(">");
            for (PacketExtension extension : extensions) {
                xml.append(extension.toXML());
            }
            for (Property property : this.properties) {
                xml.append(property.toXML());
            }
            xml.append("</").append(ELEMENT_NAME).append(">");
        } else {
            xml.append("/>");
        }
        return xml.toString();
    }

    public Boolean isReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Map<String, String> getPropertiesMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Property property : this.properties) {
            properties.put(property.getName(), property.getValue());
        }
        return properties;
    }

    public static class Property
    extends AbstractPacketExtension {
        public static final String ELEMENT_NAME = "property";
        public static final String NAME_ATTR_NAME = "name";
        public static final String VALUE_ATTR_NAME = "value";

        public Property() {
            super(null, ELEMENT_NAME);
        }

        public Property(String name, String value) {
            this();
            this.setName(name);
            this.setValue(value);
        }

        public void setName(String name) {
            this.setAttribute(NAME_ATTR_NAME, name);
        }

        public String getName() {
            return this.getAttributeAsString(NAME_ATTR_NAME);
        }

        public void setValue(String value) {
            this.setAttribute(VALUE_ATTR_NAME, value);
        }

        public String getValue() {
            return this.getAttributeAsString(VALUE_ATTR_NAME);
        }
    }
}

