/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.util;

import java.net.URI;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RTPHdrExtPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpFbPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.service.neomedia.MediaType;
import org.jivesoftware.smack.packet.PacketExtension;

public class JingleOfferFactory {
    private JingleOfferFactory() {
    }

    public static ContentPacketExtension createContentForMedia(MediaType mediaType) {
        ContentPacketExtension content = new ContentPacketExtension(ContentPacketExtension.CreatorEnum.initiator, mediaType.name().toLowerCase());
        content.setSenders(ContentPacketExtension.SendersEnum.both);
        if (mediaType == MediaType.AUDIO) {
            RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
            rtpDesc.setMedia("audio");
            RTPHdrExtPacketExtension ssrcAudioLevel = new RTPHdrExtPacketExtension();
            ssrcAudioLevel.setID("1");
            ssrcAudioLevel.setURI(URI.create("urn:ietf:params:rtp-hdrext:ssrc-audio-level"));
            rtpDesc.addExtmap(ssrcAudioLevel);
            PayloadTypePacketExtension opus = new PayloadTypePacketExtension();
            opus.setId(111);
            opus.setName("opus");
            opus.setClockrate(48000);
            opus.setChannels(2);
            rtpDesc.addPayloadType(opus);
            ParameterPacketExtension opusMinptime = new ParameterPacketExtension();
            opusMinptime.setName("minptime");
            opusMinptime.setValue("10");
            opus.addParameter(opusMinptime);
            PayloadTypePacketExtension isac16 = new PayloadTypePacketExtension();
            isac16.setId(103);
            isac16.setName("ISAC");
            isac16.setClockrate(16000);
            rtpDesc.addPayloadType(isac16);
            PayloadTypePacketExtension isac32 = new PayloadTypePacketExtension();
            isac32.setId(104);
            isac32.setName("ISAC");
            isac32.setClockrate(32000);
            rtpDesc.addPayloadType(isac32);
            PayloadTypePacketExtension pcmu = new PayloadTypePacketExtension();
            pcmu.setId(0);
            pcmu.setName("PCMU");
            pcmu.setClockrate(8000);
            rtpDesc.addPayloadType(pcmu);
            PayloadTypePacketExtension pcma = new PayloadTypePacketExtension();
            pcma.setId(8);
            pcma.setName("PCMA");
            pcma.setClockrate(8000);
            rtpDesc.addPayloadType(pcma);
            PayloadTypePacketExtension cn = new PayloadTypePacketExtension();
            cn.setId(106);
            cn.setName("CN");
            cn.setClockrate(32000);
            rtpDesc.addPayloadType(cn);
            PayloadTypePacketExtension cn16 = new PayloadTypePacketExtension();
            cn16.setId(105);
            cn16.setName("CN");
            cn16.setClockrate(16000);
            rtpDesc.addPayloadType(cn16);
            PayloadTypePacketExtension cn8 = new PayloadTypePacketExtension();
            cn8.setId(13);
            cn8.setName("CN");
            cn8.setClockrate(8000);
            rtpDesc.addPayloadType(cn8);
            PayloadTypePacketExtension teleEvent = new PayloadTypePacketExtension();
            teleEvent.setId(126);
            teleEvent.setName("telephone-event");
            teleEvent.setClockrate(8000);
            rtpDesc.addPayloadType(teleEvent);
            rtpDesc.setAttribute("maxptime", (Object)"60");
            content.addChildExtension((PacketExtension)rtpDesc);
        } else if (mediaType == MediaType.VIDEO) {
            RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
            rtpDesc.setMedia("video");
            RTPHdrExtPacketExtension toOffset = new RTPHdrExtPacketExtension();
            toOffset.setID("2");
            toOffset.setURI(URI.create("urn:ietf:params:rtp-hdrext:toffset"));
            rtpDesc.addExtmap(toOffset);
            RTPHdrExtPacketExtension absSendTime = new RTPHdrExtPacketExtension();
            absSendTime.setID("3");
            absSendTime.setURI(URI.create("http://www.webrtc.org/experiments/rtp-hdrext/abs-send-time"));
            rtpDesc.addExtmap(absSendTime);
            PayloadTypePacketExtension vp8 = new PayloadTypePacketExtension();
            vp8.setId(100);
            vp8.setName("VP8");
            vp8.setClockrate(90000);
            rtpDesc.addPayloadType(vp8);
            RtcpFbPacketExtension ccmFir = new RtcpFbPacketExtension();
            ccmFir.setFeedbackType("ccm");
            ccmFir.setFeedbackSubtype("fir");
            vp8.addRtcpFeedbackType(ccmFir);
            RtcpFbPacketExtension nack = new RtcpFbPacketExtension();
            nack.setFeedbackType("nack");
            vp8.addRtcpFeedbackType(nack);
            RtcpFbPacketExtension remb = new RtcpFbPacketExtension();
            remb.setFeedbackType("goog-remb");
            vp8.addRtcpFeedbackType(remb);
            PayloadTypePacketExtension red = new PayloadTypePacketExtension();
            red.setId(116);
            red.setName("red");
            red.setClockrate(90000);
            rtpDesc.addPayloadType(red);
            PayloadTypePacketExtension ulpfec = new PayloadTypePacketExtension();
            ulpfec.setId(117);
            ulpfec.setName("ulpfec");
            ulpfec.setClockrate(90000);
            rtpDesc.addPayloadType(ulpfec);
            content.addChildExtension((PacketExtension)rtpDesc);
        } else if (mediaType == MediaType.DATA) {
            RtpDescriptionPacketExtension rdpe = new RtpDescriptionPacketExtension();
            rdpe.setMedia("application");
            content.addChildExtension((PacketExtension)rdpe);
        } else {
            return null;
        }
        content.addChildExtension((PacketExtension)new IceUdpTransportPacketExtension());
        return content;
    }
}

