/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import org.jitsi.jicofo.MediaSSRCGroupMap;
import org.jitsi.jicofo.SSRCGroup;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.XmppChatMember;
import org.jitsi.protocol.xmpp.util.MediaSSRCMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Participant {
    private final XmppChatMember roomMember;
    private JingleSession jingleSession;
    private ColibriConferenceIQ colibriChannelsInfo;
    private MediaSSRCMap ssrcs = new MediaSSRCMap();
    private MediaSSRCGroupMap ssrcGroups = new MediaSSRCGroupMap();
    private MediaSSRCMap ssrcsToAdd = new MediaSSRCMap();
    private MediaSSRCGroupMap ssrcGroupsToAdd = new MediaSSRCGroupMap();
    private MediaSSRCMap ssrcsToRemove = new MediaSSRCMap();
    private MediaSSRCGroupMap ssrcGroupsToRemove = new MediaSSRCGroupMap();
    private boolean hasBundleSupport;
    private boolean isSipGateway;
    private boolean mutedStatus;
    private String authenticatedIdentity;

    public Participant(XmppChatMember roomMember) {
        this.roomMember = roomMember;
    }

    public JingleSession getJingleSession() {
        return this.jingleSession;
    }

    public void setJingleSession(JingleSession jingleSession) {
        this.jingleSession = jingleSession;
    }

    public XmppChatMember getChatMember() {
        return this.roomMember;
    }

    public void addSSRCsFromContent(List<ContentPacketExtension> answer) {
        this.ssrcs.add(MediaSSRCMap.getSSRCsFromContent(answer));
    }

    public void removeSSRCs(MediaSSRCMap ssrcMap) {
        this.ssrcs.remove(ssrcMap);
    }

    public MediaSSRCMap getSSRCS() {
        return this.ssrcs;
    }

    public MediaSSRCMap getSSRCsCopy() {
        return this.ssrcs.copyShallow();
    }

    public MediaSSRCGroupMap getSSRCGroupsCopy() {
        return this.ssrcGroups.copy();
    }

    public boolean hasSsrcsToAdd() {
        return !this.ssrcsToAdd.isEmpty() || !this.ssrcGroupsToAdd.isEmpty();
    }

    public void clearSsrcsToAdd() {
        this.ssrcsToAdd = new MediaSSRCMap();
        this.ssrcGroupsToAdd = new MediaSSRCGroupMap();
    }

    public void clearSsrcsToRemove() {
        this.ssrcsToRemove = new MediaSSRCMap();
        this.ssrcGroupsToRemove = new MediaSSRCGroupMap();
    }

    public boolean hasSsrcsToRemove() {
        return !this.ssrcsToRemove.isEmpty() || !this.ssrcGroupsToRemove.isEmpty();
    }

    public MediaSSRCMap getSsrcsToAdd() {
        return this.ssrcsToAdd;
    }

    public MediaSSRCMap getSsrcsToRemove() {
        return this.ssrcsToRemove;
    }

    public void scheduleSSRCsToAdd(MediaSSRCMap ssrcMap) {
        this.ssrcsToAdd.add(ssrcMap);
    }

    public void scheduleSSRCsToRemove(MediaSSRCMap ssrcMap) {
        this.ssrcsToRemove.add(ssrcMap);
    }

    public void setColibriChannelsInfo(ColibriConferenceIQ colibriChannelsInfo) {
        this.colibriChannelsInfo = colibriChannelsInfo;
    }

    public ColibriConferenceIQ getColibriChannelsInfo() {
        return this.colibriChannelsInfo;
    }

    public void setHasBundleSupport(boolean hasBundleSupport) {
        this.hasBundleSupport = hasBundleSupport;
    }

    public boolean hasBundleSupport() {
        return this.hasBundleSupport;
    }

    public boolean isSipGateway() {
        return this.isSipGateway;
    }

    public void setIsSipGateway(boolean isSipGateway) {
        this.isSipGateway = isSipGateway;
    }

    public void setMuted(boolean mutedStatus) {
        this.mutedStatus = mutedStatus;
    }

    public boolean isMuted() {
        return this.mutedStatus;
    }

    public void setAuthenticatedIdentity(String authenticatedIdentity) {
        this.authenticatedIdentity = authenticatedIdentity;
    }

    public String getAuthenticatedIdentity() {
        return this.authenticatedIdentity;
    }

    public List<SSRCGroup> getSSRCGroupsForMedia(String media) {
        return this.ssrcGroups.getSSRCGroupsForMedia(media);
    }

    public MediaSSRCGroupMap getSSRCGroups() {
        return this.ssrcGroups;
    }

    public void addSSRCGroupsFromContent(List<ContentPacketExtension> contents) {
        for (ContentPacketExtension content : contents) {
            List<SSRCGroup> groups = SSRCGroup.getSSRCGroupsForContent(content);
            this.ssrcGroups.addSSRCGroups(content.getName(), groups);
        }
    }

    public void scheduleSSRCGroupsToAdd(MediaSSRCGroupMap ssrcGroups) {
        this.ssrcGroupsToAdd.add(ssrcGroups);
    }

    public void scheduleSSRCGroupsToRemove(MediaSSRCGroupMap ssrcGroups) {
        this.ssrcGroupsToRemove.add(ssrcGroups);
    }

    public MediaSSRCGroupMap getSSRCGroupsToAdd() {
        return this.ssrcGroupsToAdd;
    }

    public MediaSSRCGroupMap getSsrcGroupsToRemove() {
        return this.ssrcGroupsToRemove;
    }

    public void removeSSRCGroups(MediaSSRCGroupMap ssrcGroupsToRemove) {
        this.ssrcGroups.remove(ssrcGroupsToRemove);
    }
}

