/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.JitsiMeetConference;

public class ChatRoomRoleAndPresence
implements ChatRoomMemberPresenceListener,
ChatRoomMemberRoleListener,
ChatRoomLocalUserRoleListener {
    private static final Logger logger = Logger.getLogger(ChatRoomRoleAndPresence.class);
    private final JitsiMeetConference conference;
    private final ChatRoom chatRoom;
    private ChatRoomMemberRole focusRole;
    private ChatRoomMember moderator;

    public ChatRoomRoleAndPresence(JitsiMeetConference conference, ChatRoom chatRoom) {
        this.conference = conference;
        this.chatRoom = chatRoom;
    }

    public void init() {
        this.chatRoom.addLocalUserRoleListener((ChatRoomLocalUserRoleListener)this);
        this.chatRoom.addMemberPresenceListener((ChatRoomMemberPresenceListener)this);
        this.chatRoom.addMemberRoleListener((ChatRoomMemberRoleListener)this);
    }

    public void dispose() {
        this.chatRoom.removelocalUserRoleListener((ChatRoomLocalUserRoleListener)this);
        this.chatRoom.removeMemberPresenceListener((ChatRoomMemberPresenceListener)this);
        this.chatRoom.removeMemberRoleListener((ChatRoomMemberRoleListener)this);
    }

    public void memberPresenceChanged(ChatRoomMemberPresenceChangeEvent evt) {
        logger.info((Object)("Chat room event " + evt));
        logger.info((Object)("Participants count: " + evt.getChatRoom().getMembersCount()));
        ChatRoomMember sourceMember = evt.getChatRoomMember();
        String eventType = evt.getEventType();
        if ("MemberJoined".equals(eventType)) {
            if (this.moderator == null) {
                this.electNewModerator();
            }
            this.conference.onMemberJoined(sourceMember);
        } else if ("MemberLeft".equals(eventType) || "MemberKicked".equals(eventType) || "MemberQuit".equals(eventType)) {
            if (this.moderator == sourceMember) {
                logger.info((Object)"Moderator has left hte room !");
                this.moderator = null;
                this.electNewModerator();
            }
            if ("MemberKicked".equals(eventType)) {
                this.conference.onMemberKicked(sourceMember);
            } else {
                this.conference.onMemberLeft(sourceMember);
            }
        } else {
            logger.warn((Object)("Unhandled event: " + evt.getEventType()));
        }
    }

    private void electNewModerator() {
        if (this.focusRole == null) {
            return;
        }
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (JitsiMeetConference.isFocusMember(member) || this.conference.isSipGateway(member)) continue;
            if (ChatRoomMemberRole.MODERATOR.compareTo((Enum)member.getRole()) >= 0) {
                this.moderator = member;
                logger.info((Object)("Moderator already in the room: " + member.getName()));
                break;
            }
            try {
                this.chatRoom.grantModerator(member.getName());
                logger.info((Object)("Granted moderator to " + member.getContactAddress()));
                this.moderator = member;
                break;
            }
            catch (RuntimeException e) {
                logger.error((Object)("Failed to grant moderator status to " + member.getName()), (Throwable)e);
            }
        }
    }

    public void memberRoleChanged(ChatRoomMemberRoleChangeEvent evt) {
        logger.info((Object)("Role update event " + evt));
    }

    public void localUserRoleChanged(ChatRoomLocalUserRoleChangeEvent evt) {
        logger.info((Object)("Focus role: " + evt.getNewRole() + " init: " + evt.isInitial()));
        this.focusRole = evt.getNewRole();
        if (ChatRoomMemberRole.MODERATOR.compareTo((Enum)this.focusRole) < 0) {
            logger.error((Object)"Focus must be a moderator!");
            this.conference.stop();
            return;
        }
        if (evt.isInitial() && this.moderator == null) {
            this.electNewModerator();
        }
    }
}

