/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.Token;
import gov.nist.javax.sip.header.Protocol;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import java.text.ParseException;

public class ViaParser
extends HeaderParser {
    public ViaParser(String via) {
        super(via);
    }

    public ViaParser(Lexer lexer) {
        super(lexer);
    }

    private void parseVia(Via v) throws ParseException {
        this.lexer.match(4095);
        Token protocolName = this.lexer.getNextToken();
        this.lexer.SPorHT();
        this.lexer.match(47);
        this.lexer.SPorHT();
        this.lexer.match(4095);
        this.lexer.SPorHT();
        Token protocolVersion = this.lexer.getNextToken();
        this.lexer.SPorHT();
        this.lexer.match(47);
        this.lexer.SPorHT();
        this.lexer.match(4095);
        this.lexer.SPorHT();
        Token transport = this.lexer.getNextToken();
        this.lexer.SPorHT();
        Protocol protocol = new Protocol();
        protocol.setProtocolName(protocolName.getTokenValue());
        protocol.setProtocolVersion(protocolVersion.getTokenValue());
        protocol.setTransport(transport.getTokenValue());
        v.setSentProtocol(protocol);
        HostNameParser hnp = new HostNameParser(this.getLexer());
        HostPort hostPort = hnp.hostPort(true);
        v.setSentBy(hostPort);
        this.lexer.SPorHT();
        while (this.lexer.lookAhead(0) == ';') {
            String branchId;
            this.lexer.consume(1);
            this.lexer.SPorHT();
            NameValue nameValue = this.nameValue();
            String name = nameValue.getName();
            if (name.equals("branch") && (branchId = (String)nameValue.getValueAsObject()) == null) {
                throw new ParseException("null branch Id", this.lexer.getPtr());
            }
            v.setParameter(nameValue);
            this.lexer.SPorHT();
        }
        if (this.lexer.lookAhead(0) == '(') {
            this.lexer.selectLexer("charLexer");
            this.lexer.consume(1);
            StringBuilder comment = new StringBuilder();
            while (true) {
                char ch;
                if ((ch = this.lexer.lookAhead(0)) == ')') {
                    this.lexer.consume(1);
                    break;
                }
                if (ch == '\\') {
                    Token tok = this.lexer.getNextToken();
                    comment.append(tok.getTokenValue());
                    this.lexer.consume(1);
                    tok = this.lexer.getNextToken();
                    comment.append(tok.getTokenValue());
                    this.lexer.consume(1);
                    continue;
                }
                if (ch == '\n') break;
                comment.append(ch);
                this.lexer.consume(1);
            }
            v.setComment(comment.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NameValue nameValue() throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            Token name;
            block11: {
                NameValue nameValue;
                this.lexer.match(4095);
                name = this.lexer.getNextToken();
                this.lexer.SPorHT();
                try {
                    boolean quoted = false;
                    char la = this.lexer.lookAhead(0);
                    if (la != '=') break block11;
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    if (name.getTokenValue().compareToIgnoreCase("received") == 0) {
                        str = this.lexer.byteStringNoSemicolon();
                    } else if (this.lexer.lookAhead(0) == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else {
                        this.lexer.match(4095);
                        Token value = this.lexer.getNextToken();
                        str = value.getTokenValue();
                    }
                    NameValue nv = new NameValue(name.getTokenValue().toLowerCase(), str);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    nameValue = nv;
                }
                catch (ParseException ex) {
                    NameValue nameValue2 = new NameValue(name.getTokenValue(), null);
                    Object var8_12 = null;
                    if (!debug) return nameValue2;
                    this.dbg_leave("nameValue");
                    return nameValue2;
                }
                Object var8_10 = null;
                if (!debug) return nameValue;
                this.dbg_leave("nameValue");
                return nameValue;
            }
            NameValue nameValue = new NameValue(name.getTokenValue().toLowerCase(), null);
            Object var8_11 = null;
            if (!debug) return nameValue;
            this.dbg_leave("nameValue");
            return nameValue;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!debug) throw throwable;
            this.dbg_leave("nameValue");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPHeader parse() throws ParseException {
        ViaList viaList;
        block4: {
            if (debug) {
                this.dbg_enter("parse");
            }
            try {
                ViaList viaList2 = new ViaList();
                this.lexer.match(2064);
                this.lexer.SPorHT();
                this.lexer.match(58);
                this.lexer.SPorHT();
                do {
                    Via v = new Via();
                    this.parseVia(v);
                    viaList2.add(v);
                    this.lexer.SPorHT();
                    if (this.lexer.lookAhead(0) != ',') continue;
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                } while (this.lexer.lookAhead(0) != '\n');
                this.lexer.match(10);
                viaList = viaList2;
                Object var4_3 = null;
                if (!debug) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_4 = null;
                    if (!debug) break block5;
                    this.dbg_leave("parse");
                }
                throw throwable;
            }
            this.dbg_leave("parse");
        }
        return viaList;
    }
}

