/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.ratecontrol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.ratecontrol.BitrateAdaptor;
import org.jitsi.videobridge.ratecontrol.SimulcastAdaptor;
import org.jitsi.videobridge.ratecontrol.VideoChannelLastNAdaptor;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.osgi.framework.BundleContext;

public class BitrateController {
    private static boolean configurationInitialized = false;
    private static int DECREASE_LAG_MS = 10000;
    private static final String DECREASE_LAG_MS_PNAME = BitrateController.class.getName() + ".DECREASE_LAG_MS";
    private static int INCREASE_LAG_MS = 20000;
    private static final String INCREASE_LAG_MS_PNAME = BitrateController.class.getName() + ".INCREASE_LAG_MS";
    private static int INITIAL_INTERVAL_MS = 70000;
    private static final String INITIAL_INTERVAL_MS_PNAME = BitrateController.class.getName() + ".INITIAL_INTERVAL_MS";
    private static final Logger logger = Logger.getLogger(BitrateController.class);
    private static int MIN_ASSUMED_ENDPOINT_BITRATE_BPS = 400000;
    private static final String MIN_ASSUMED_ENDPOINT_BITRATE_BPS_PNAME = BitrateController.class.getName() + ".MIN_ASSUMED_ENDPOINT_BITRATE_BPS";
    private static int REMB_AVERAGE_INTERVAL_MS = 5000;
    private static final String REMB_AVERAGE_INTERVAL_MS_PNAME = BitrateController.class.getName() + ".REMB_AVERAGE_INTERVAL_MS";
    private static double REMB_MULT_CONSTANT = 1.0;
    private static final String REMB_MULT_CONSTANT_PNAME = BitrateController.class.getName() + ".REMB_MULT_CONSTANT";
    private BitrateAdaptor bitrateAdaptor;
    private boolean bitrateAdaptorSet = false;
    private final VideoChannel channel;
    private long firstRemb = -1L;
    private long lastNonDecrease = -1L;
    private long lastNonIncrease = -1L;
    private final ReceivedRembList receivedRembs = new ReceivedRembList(REMB_AVERAGE_INTERVAL_MS);

    public BitrateController(VideoChannel channel) {
        this.channel = channel;
        this.initializeConfiguration();
    }

    public int calcNumEndpointsThatFitIn() {
        long availableBandwidth;
        long now = System.currentTimeMillis();
        long remainingBandwidth = availableBandwidth = (long)((double)this.receivedRembs.getAverage(now) * REMB_MULT_CONSTANT);
        int numEndpointsThatFitIn = 0;
        Iterator<Endpoint> it = this.channel.getReceivingEndpoints();
        Endpoint thisEndpoint = this.channel.getEndpoint();
        while (it.hasNext()) {
            Endpoint endpoint = it.next();
            if (endpoint == null || endpoint.equals(thisEndpoint)) continue;
            long endpointBitrate = this.getEndpointBitrate(endpoint);
            if (remainingBandwidth < endpointBitrate) break;
            ++numEndpointsThatFitIn;
            remainingBandwidth -= endpointBitrate;
        }
        return numEndpointsThatFitIn;
    }

    public VideoChannel getChannel() {
        return this.channel;
    }

    private long getEndpointBitrate(Endpoint endpoint) {
        SimulcastManager mySM = this.channel.getSimulcastManager();
        long bitrate = 0L;
        for (RtpChannel channel : endpoint.getChannels(MediaType.VIDEO)) {
            if (channel == null || !(channel instanceof VideoChannel)) continue;
            VideoChannel vc = (VideoChannel)channel;
            SimulcastManager peerSM = vc.getSimulcastManager();
            if (mySM != null && peerSM != null && peerSM.hasLayers()) {
                bitrate += mySM.getIncomingBitrate(peerSM, true);
                continue;
            }
            bitrate += ((VideoChannel)channel).getIncomingBitrate();
        }
        return Math.max(bitrate, (long)MIN_ASSUMED_ENDPOINT_BITRATE_BPS);
    }

    private BitrateAdaptor getOrCreateBitrateAdaptor() {
        if (this.bitrateAdaptor == null && !this.bitrateAdaptorSet) {
            this.bitrateAdaptorSet = true;
            if (this.channel.getAdaptiveLastN()) {
                this.bitrateAdaptor = new VideoChannelLastNAdaptor(this);
            } else if (this.channel.getAdaptiveSimulcast()) {
                this.bitrateAdaptor = new SimulcastAdaptor(this);
            }
        }
        return this.bitrateAdaptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConfiguration() {
        Class<BitrateController> clazz = BitrateController.class;
        synchronized (BitrateController.class) {
            if (configurationInitialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            configurationInitialized = true;
            ConfigurationService cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)this.channel.getBundleContext(), ConfigurationService.class);
            if (cfg != null) {
                INCREASE_LAG_MS = cfg.getInt(INCREASE_LAG_MS_PNAME, INCREASE_LAG_MS);
                INCREASE_LAG_MS = cfg.getInt(DECREASE_LAG_MS_PNAME, DECREASE_LAG_MS);
                INITIAL_INTERVAL_MS = cfg.getInt(INITIAL_INTERVAL_MS_PNAME, INITIAL_INTERVAL_MS);
                String rembMultConstantStr = cfg.getString(REMB_MULT_CONSTANT_PNAME, null);
                if (rembMultConstantStr != null) {
                    try {
                        REMB_MULT_CONSTANT = Double.parseDouble(rembMultConstantStr);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                REMB_AVERAGE_INTERVAL_MS = cfg.getInt(REMB_AVERAGE_INTERVAL_MS_PNAME, REMB_AVERAGE_INTERVAL_MS);
                MIN_ASSUMED_ENDPOINT_BITRATE_BPS = cfg.getInt(MIN_ASSUMED_ENDPOINT_BITRATE_BPS_PNAME, MIN_ASSUMED_ENDPOINT_BITRATE_BPS);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void receivedREMB(long remb) {
        BitrateAdaptor bitrateAdaptor = this.getOrCreateBitrateAdaptor();
        if (bitrateAdaptor == null) {
            return;
        }
        long now = System.currentTimeMillis();
        int receivingEndpointsSize = this.channel.getReceivingEndpointsSize();
        if (this.firstRemb == -1L) {
            this.firstRemb = now;
        }
        this.receivedRembs.add(now, remb);
        if (now - this.firstRemb <= (long)INITIAL_INTERVAL_MS) {
            return;
        }
        if (!bitrateAdaptor.touch()) {
            return;
        }
        int numEndpointsThatFitIn = this.calcNumEndpointsThatFitIn();
        if (numEndpointsThatFitIn < receivingEndpointsSize) {
            this.lastNonIncrease = now;
            if (now - this.lastNonDecrease >= (long)DECREASE_LAG_MS) {
                this.lastNonDecrease = now;
                bitrateAdaptor.decrease();
            }
        } else if (numEndpointsThatFitIn == receivingEndpointsSize) {
            this.lastNonDecrease = now;
        } else if (numEndpointsThatFitIn > receivingEndpointsSize) {
            this.lastNonDecrease = now;
            if (now - this.lastNonIncrease >= (long)INCREASE_LAG_MS) {
                this.lastNonIncrease = now;
                bitrateAdaptor.increase();
            }
        }
    }

    private static class ReceivedRembList {
        private final long period;
        private final Map<Long, Long> receivedRembs = new HashMap<Long, Long>();
        private long sum = 0L;
        private final List<Long> toRemove = new ArrayList<Long>();

        private ReceivedRembList(long period) {
            this.period = period;
        }

        private void add(long time, long rate) {
            this.sum += rate;
            this.receivedRembs.put(time, rate);
            this.clean(time);
        }

        private void clean(long time) {
            long oldest = time - this.period;
            this.toRemove.clear();
            for (Map.Entry<Long, Long> entry : this.receivedRembs.entrySet()) {
                long t = entry.getKey();
                if (t >= oldest) continue;
                this.toRemove.add(t);
            }
            Iterator<Object> i$ = this.toRemove.iterator();
            while (i$.hasNext()) {
                long t = (Long)i$.next();
                this.sum -= this.receivedRembs.remove(t).longValue();
            }
        }

        private long getAverage(long time) {
            this.clean(time);
            int size = this.receivedRembs.size();
            return size == 0 ? 0L : this.sum / (long)size;
        }
    }
}

