/**
 * $RCSfile: $
 * $Revision: $
 * $Date: $
 *
 * Copyright 2005 Jive Software.
 *
 * All rights reserved. Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.xmpp.packet;

import org.dom4j.DocumentFactory;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: Gaston
 * Date: Apr 11, 2005
 * Time: 10:16:52 AM
 * To change this template use File | Settings | File Templates.
 */
public class DiscoInfo extends IQ {

    public Collection<Identity> getIdentities() {
        Collection<Identity> answer = new ArrayList<Identity>();
        for (Iterator it=getChildElement().elementIterator("identity"); it.hasNext();) {
            answer.add(new Identity((Element) it.next()));
        }
        return answer;
    }

    public void addIdentity(Identity identity) {
        getChildElement().add(identity.getElement());
    }

    public Collection<String> getFeatures() {
        Collection<String> answer = new ArrayList<String>();
        for (Iterator it=getChildElement().elementIterator("feature"); it.hasNext();) {
            answer.add(((Element)it.next()).attributeValue("var"));
        }
        return answer;
    }

    public void addFeature(String feature) {
        getChildElement().addElement("feature").addAttribute("var", feature);
    }

    public static class Identity {
        private Element element;

        Identity(Element element) {
            this.element = element;
        }

        public Identity(String category, String type, String name) {
            this.element =
                    DocumentFactory.getInstance().createDocument().addElement("identity")
                    .createCopy();
            // Set the new attributes
            element.addAttribute("category", category);
            element.addAttribute("type", type);
            element.addAttribute("name", name);
        }

        public String getCategory() {
            return element.attributeValue("category");
        }

        public String getType() {
            return element.attributeValue("type");
        }

        public String getName() {
            return element.attributeValue("name");
        }

        Element getElement() {
            return element;
        }
    }
}
