/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson;

import com.owlike.genson.Operations;
import java.util.HashMap;
import java.util.Map;

public final class ThreadLocalHolder {
    private static final ThreadLocal<Map<String, Object>> _data = new ThreadLocal();

    public static Object store(String key, Object parameter) {
        Operations.checkNotNull(key);
        return ThreadLocalHolder.getPutIfMissing().put(key, parameter);
    }

    public static <T> T remove(String key, Class<T> valueType) {
        Operations.checkNotNull(key, valueType);
        Map<String, Object> map = ThreadLocalHolder.getPutIfMissing();
        T value = valueType.cast(map.get(key));
        map.remove(key);
        return value;
    }

    public static <T> T get(String key, Class<T> valueType) {
        Operations.checkNotNull(key, valueType);
        return valueType.cast(ThreadLocalHolder.getPutIfMissing().get(key));
    }

    private static Map<String, Object> getPutIfMissing() {
        Map<String, Object> map = _data.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            _data.set(map);
        }
        return map;
    }
}

