/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.out;

import java.nio.ByteBuffer;
import java.util.List;
import net.sf.jqql.Util;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets.out.ClusterCommandPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterCreateTempPacket
extends ClusterCommandPacket {
    private int parentClusterId;
    private String name;
    private List<Integer> members;
    private byte type;

    public ClusterCreateTempPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public ClusterCreateTempPacket(QQUser qQUser) {
        super(qQUser);
        this.subCommand = (byte)48;
    }

    @Override
    public String getPacketName() {
        return "Cluster - Create Temp Cluster _08Packet";
    }

    @Override
    protected void putBody(ByteBuffer byteBuffer) {
        byteBuffer.put(this.subCommand);
        byteBuffer.put(this.type);
        byteBuffer.putInt(this.parentClusterId);
        byte[] byArray = Util.getBytes(this.name);
        byteBuffer.put((byte)(byArray.length & 0xFF));
        byteBuffer.put(byArray);
        for (int n : this.members) {
            byteBuffer.putInt(n);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getParentClusterId() {
        return this.parentClusterId;
    }

    public void setParentClusterId(int n) {
        this.parentClusterId = n;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte by) {
        this.type = by;
    }

    public List<Integer> getMembers() {
        return this.members;
    }

    public void setMembers(List<Integer> list) {
        this.members = list;
    }
}

