/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class DynamicByteBuffer {
    private ByteBuffer buffer;

    public DynamicByteBuffer(int cap, boolean useDirectBuffer) {
        this.buffer = useDirectBuffer ? ByteBuffer.allocateDirect(cap) : ByteBuffer.allocate(cap);
    }

    public DynamicByteBuffer(byte[] array) {
        this.buffer = array != null ? ByteBuffer.wrap(array) : ByteBuffer.allocate(0);
    }

    public DynamicByteBuffer(byte[] array, int offset, int length) {
        this.buffer = ByteBuffer.wrap(array, offset, length);
    }

    public DynamicByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public DynamicByteBuffer compact() {
        this.buffer.compact();
        return this;
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public DynamicByteBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    public DynamicByteBuffer get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    public char getChar() {
        this.check();
        return this.buffer.getChar();
    }

    public char getChar(int index) {
        this.check();
        return this.buffer.getChar(index);
    }

    public double getDouble() {
        this.check();
        return this.buffer.getDouble();
    }

    public double getDouble(int index) {
        this.check();
        return this.buffer.getDouble(index);
    }

    public float getFloat() {
        this.check();
        return this.buffer.getFloat();
    }

    public float getFloat(int index) {
        this.check();
        return this.buffer.getFloat(index);
    }

    public int getInt() {
        this.check();
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        this.check();
        return this.buffer.getInt(index);
    }

    public long getLong() {
        this.check();
        return this.buffer.getLong();
    }

    public long getLong(int index) {
        this.check();
        return this.buffer.getLong(index);
    }

    public short getShort() {
        this.check();
        return this.buffer.getShort();
    }

    public short getShort(int index) {
        this.check();
        return this.buffer.getShort(index);
    }

    public DynamicByteBuffer put(byte b) {
        this.ensureSize(1);
        this.buffer.put(b);
        return this;
    }

    public DynamicByteBuffer put(int index, byte b) {
        this.ensureSize(1);
        this.buffer.put(index, b);
        return this;
    }

    public DynamicByteBuffer put(byte[] src) {
        this.ensureSize(src.length);
        this.buffer.put(src);
        return this;
    }

    public DynamicByteBuffer put(byte[] src, int offset, int length) {
        this.ensureSize(length);
        this.buffer.put(src, offset, length);
        return this;
    }

    public DynamicByteBuffer put(ByteBuffer src) {
        this.ensureSize(src.remaining());
        this.buffer.put(src);
        return this;
    }

    public DynamicByteBuffer putChar(int index, char value) {
        this.ensureSize(2);
        this.buffer.putChar(index, value);
        return this;
    }

    public DynamicByteBuffer putChar(char value) {
        this.ensureSize(2);
        this.buffer.putChar(value);
        return this;
    }

    public DynamicByteBuffer putDouble(int index, double value) {
        this.ensureSize(8);
        this.buffer.putDouble(index, value);
        return this;
    }

    public DynamicByteBuffer putDouble(double value) {
        this.ensureSize(8);
        this.buffer.putDouble(value);
        return this;
    }

    public DynamicByteBuffer putFloat(int index, float value) {
        this.ensureSize(4);
        this.buffer.putFloat(index, value);
        return this;
    }

    public DynamicByteBuffer putFloat(float value) {
        this.ensureSize(4);
        this.buffer.putFloat(value);
        return this;
    }

    public DynamicByteBuffer putInt(int index, int value) {
        this.ensureSize(4);
        this.buffer.putInt(index, value);
        return this;
    }

    public DynamicByteBuffer putInt(int value) {
        this.ensureSize(4);
        this.buffer.putInt(value);
        return this;
    }

    public DynamicByteBuffer putLong(int index, long value) {
        this.ensureSize(8);
        this.buffer.putLong(index, value);
        return this;
    }

    public DynamicByteBuffer putLong(long value) {
        this.ensureSize(8);
        this.buffer.putLong(value);
        return this;
    }

    public DynamicByteBuffer putShort(int index, short value) {
        this.ensureSize(2);
        this.buffer.putShort(index, value);
        return this;
    }

    public DynamicByteBuffer putShort(short value) {
        this.ensureSize(2);
        this.buffer.putShort(value);
        return this;
    }

    private void ensureSize(int i) {
        this.check();
        if (this.buffer.remaining() < i) {
            int newCap = Math.max(this.buffer.limit() << 1, this.buffer.limit() + i);
            ByteBuffer newBuffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newCap) : ByteBuffer.allocate(newCap);
            newBuffer.order(this.buffer.order());
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public DynamicByteBuffer duplicate() {
        this.check();
        return new DynamicByteBuffer(this.buffer.duplicate());
    }

    public DynamicByteBuffer slice() {
        this.check();
        return new DynamicByteBuffer(this.buffer.slice());
    }

    public DynamicByteBuffer clear() {
        this.check();
        this.buffer.clear();
        return this;
    }

    public DynamicByteBuffer flip() {
        this.check();
        this.buffer.flip();
        return this;
    }

    public int limit() {
        this.check();
        return this.buffer.limit();
    }

    public DynamicByteBuffer limit(int newLimit) {
        this.check();
        this.buffer.limit(newLimit);
        return this;
    }

    public DynamicByteBuffer mark() {
        this.check();
        this.buffer.mark();
        return this;
    }

    public int position() {
        this.check();
        return this.buffer.position();
    }

    public DynamicByteBuffer position(int newPosition) {
        this.check();
        this.buffer.position(newPosition);
        return this;
    }

    public int remaining() {
        this.check();
        return this.buffer.remaining();
    }

    public DynamicByteBuffer reset() {
        this.check();
        this.buffer.reset();
        return this;
    }

    public DynamicByteBuffer rewind() {
        this.check();
        this.buffer.rewind();
        return this;
    }

    public int capacity() {
        this.check();
        return this.buffer.capacity();
    }

    public boolean hasRemaining() {
        this.check();
        return this.buffer.hasRemaining();
    }

    public byte[] array() {
        this.check();
        if (!this.buffer.isDirect()) {
            return this.buffer.array();
        }
        ByteBuffer duplicate = this.buffer.duplicate();
        duplicate.flip();
        byte[] newBuffer = new byte[duplicate.limit()];
        duplicate.get(newBuffer);
        return newBuffer;
    }

    public ByteOrder order() {
        this.check();
        return this.buffer.order();
    }

    public DynamicByteBuffer order(ByteOrder order) {
        this.check();
        this.buffer.order(order);
        return this;
    }

    public void close() {
        this.buffer = null;
    }

    private void check() {
        if (this.buffer == null) {
            throw new IllegalStateException("Buffer is closed!");
        }
    }

    public boolean isDirect() {
        this.check();
        return this.buffer.isDirect();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DynamicByteBuffer{");
        if (this.buffer != null) {
            sb.append("position=").append(this.buffer.position());
            sb.append(", limit=").append(this.buffer.limit());
            sb.append(", capacity=").append(this.buffer.capacity());
            sb.append(", order=").append(this.buffer.order());
            sb.append(", direct=").append(this.buffer.isDirect());
        } else {
            sb.append("<CLOSED>");
        }
        sb.append('}');
        return sb.toString();
    }
}

