/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.nio.serialization.Data;

public class WanOriginatedDeleteOperation
extends BaseRemoveOperation {
    private boolean success;

    public WanOriginatedDeleteOperation() {
    }

    public WanOriginatedDeleteOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    @Override
    public void run() {
        this.success = this.recordStore.remove(this.dataKey) != null;
    }

    @Override
    public Object getResponse() {
        return this.success;
    }

    @Override
    public void afterRun() {
        if (!this.success) {
            return;
        }
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        mapServiceContext.interceptAfterRemove(this.name, this.dataValue);
        mapServiceContext.getMapEventPublisher().publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
        this.invalidateNearCaches();
        this.evict(false);
    }

    @Override
    public boolean shouldBackup() {
        return this.success;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(false);
    }

    @Override
    public String toString() {
        return "DeleteOperation{" + this.name + "}";
    }
}

