/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.objeditor;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.fmj.ui.objeditor.ComponentValidationException;

public class ComponentValidator {
    private static String buildMessage(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        if (string.endsWith(":")) {
            return string + " " + string2;
        }
        return string + ": " + string2;
    }

    public void validateInteger(JComboBox jComboBox, JLabel jLabel) throws ComponentValidationException {
        Object object = jComboBox.getSelectedItem();
        String string = object == null ? null : object.toString();
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ComponentValidationException(jComboBox, ComponentValidator.buildMessage(jLabel.getText(), "not a valid number"));
        }
    }

    public void validateInteger(JTextField jTextField, JLabel jLabel) throws ComponentValidationException {
        String string = jTextField.getText();
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ComponentValidationException(jTextField, ComponentValidator.buildMessage(jLabel.getText(), "not a valid number"));
        }
    }

    public void validateNotEmpty(JComboBox jComboBox, JLabel jLabel) throws ComponentValidationException {
        String string;
        Object object = jComboBox.getSelectedItem();
        String string2 = string = object == null ? null : object.toString();
        if (string == null || string.equals("")) {
            throw new ComponentValidationException(jComboBox, ComponentValidator.buildMessage(jLabel.getText(), "may not be empty"));
        }
    }

    public void validateNotEmpty(JTextField jTextField, JLabel jLabel) throws ComponentValidationException {
        String string = jTextField.getText();
        if (string == null || string.equals("")) {
            throw new ComponentValidationException(jTextField, ComponentValidator.buildMessage(jLabel.getText(), "may not be empty"));
        }
    }
}

