/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.parser.RawStreamParser;
import net.sf.fmj.media.protocol.DelegateDataSource;
import net.sf.fmj.media.rtp.Depacketizer;

public class RawPushBufferParser
extends RawStreamParser {
    static final String NAMEBUFFER = "Raw video/audio buffer stream parser";
    private boolean started = false;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static VideoFormat jpegVideo = new VideoFormat("jpeg/rtp");
    static VideoFormat h261Video = new VideoFormat("h261/rtp");
    static VideoFormat h263Video = new VideoFormat("h263/rtp");
    final int[] h261Widths = new int[]{176, 352};
    final int[] h261Heights = new int[]{144, 288};
    final int[] h263Widths = new int[]{0, 128, 176, 352, 704, 1408, 0, 0};
    final int[] h263Heights = new int[]{0, 96, 144, 288, 576, 1152, 0, 0};
    final float[] MPEGRateTbl = new float[]{0.0f, 23.976f, 24.0f, 25.0f, 29.97f, 30.0f, 50.0f, 59.94f, 60.0f};
    public static int[][] MPASampleTbl = new int[][]{{22050, 24000, 16000, 0}, {44100, 48000, 32000, 0}};

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                for (int i = 0; i < this.tracks.length; ++i) {
                    ((FrameTrack)this.tracks[i]).stop();
                    ((FrameTrack)this.tracks[i]).close();
                }
                this.source.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.source = null;
        }
        this.started = false;
    }

    public String getName() {
        return NAMEBUFFER;
    }

    public Track[] getTracks() {
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).parse();
        }
        return this.tracks;
    }

    boolean isRTPFormat(Format format) {
        return format != null && format.getEncoding() != null && (format.getEncoding().endsWith("rtp") || format.getEncoding().endsWith("RTP"));
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PushBufferStream)this.streams[i], 1);
        }
    }

    public void reset() {
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).reset();
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (!(dataSource instanceof PushBufferDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        SourceStream[] sourceStreamArray = ((PushBufferDataSource)dataSource).getStreams();
        if (sourceStreamArray == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (sourceStreamArray.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(sourceStreamArray)) {
            throw new IncompatibleSourceException("DataSource not supported: " + dataSource);
        }
        this.source = dataSource;
        this.streams = sourceStreamArray;
    }

    public void start() throws IOException {
        if (this.started) {
            return;
        }
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).start();
        }
        this.source.start();
        this.started = true;
    }

    public void stop() {
        try {
            for (int i = 0; i < this.tracks.length; ++i) {
                ((FrameTrack)this.tracks[i]).stop();
            }
            this.source.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.started = false;
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return sourceStreamArray[0] != null && sourceStreamArray[0] instanceof PushBufferStream;
    }

    class FrameTrack
    implements Track,
    BufferTransferHandler {
        Demultiplexer parser;
        PushBufferStream pbs;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        boolean stopped = true;
        boolean closed = false;
        boolean keyFrameFound = false;
        boolean checkDepacketizer = false;
        Depacketizer depacketizer = null;
        Object keyFrameLock = new Object();

        public FrameTrack(Demultiplexer demultiplexer, PushBufferStream pushBufferStream, int n) {
            this.pbs = pushBufferStream;
            this.format = pushBufferStream.getFormat();
            if (RawPushBufferParser.this.source instanceof DelegateDataSource || !RawPushBufferParser.this.isRTPFormat(this.format)) {
                this.keyFrameFound = true;
            }
            this.bufferQ = new CircularBuffer(n);
            pushBufferStream.setTransferHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.setEnabled(false);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.closed = true;
                this.bufferQ.notifyAll();
            }
        }

        private Depacketizer findDepacketizer(String string, Format format) {
            try {
                Class<?> clazz = BasicPlugIn.getClassForName(string);
                Object obj = clazz.newInstance();
                if (!(obj instanceof Depacketizer)) {
                    return null;
                }
                Depacketizer depacketizer = (Depacketizer)obj;
                if (depacketizer.setInputFormat(format) == null) {
                    return null;
                }
                depacketizer.open();
                return depacketizer;
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
            return null;
        }

        public boolean findH261Key(Buffer buffer) {
            int n;
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n2 = buffer.getOffset();
            if (byArray[n2 + (n = 4)] != 0 || byArray[n2 + n + 1] != 1 || (byArray[n2 + n + 2] & 0xFC) != 0) {
                return false;
            }
            int n3 = byArray[n2 + n + 3] >> 3 & 1;
            int n4 = RawPushBufferParser.this.h261Widths[n3];
            int n5 = RawPushBufferParser.this.h261Heights[n3];
            this.format = new VideoFormat("h261/rtp", new Dimension(n4, n5), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findH263_1998Key(Buffer buffer) {
            int n = -1;
            int n2 = -1;
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n3 = buffer.getOffset();
            int n4 = 2 + ((byArray[n3] & 1) << 5 | (byArray[n3 + 1] & 0xF8) >> 3);
            if ((byArray[n3] & 2) != 0) {
                ++n4;
            }
            n2 = -1;
            if (n4 > 5) {
                if ((byArray[n3] & 2) == 2 && (byArray[n3 + 3] & 0xFC) == 128) {
                    n2 = n3 + 3;
                } else if ((byArray[n3 + 2] & 0xFC) == 128) {
                    n2 = n3 + 2;
                }
            } else if ((byArray[n3] & 4) == 4 && (byArray[n3 + n4] & 0xFC) == 128) {
                n2 = n3 + n4;
            }
            if (n2 < 0) {
                return false;
            }
            n = byArray[n2 + 2] >> 2 & 7;
            if (n == 7) {
                if ((byArray[n2 + 3] >> 1 & 7) == 1) {
                    n = byArray[n2 + 3] << 2 & 4 | byArray[n2 + 4] >> 6 & 3;
                } else {
                    return false;
                }
            }
            if (n < 0) {
                return false;
            }
            int n5 = RawPushBufferParser.this.h263Widths[n];
            int n6 = RawPushBufferParser.this.h263Heights[n];
            this.format = new VideoFormat("h263-1998/rtp", new Dimension(n5, n6), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findH263Key(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n = this.getH263PayloadHeaderLength(byArray, buffer.getOffset());
            int n2 = buffer.getOffset();
            if (byArray[n2 + n] != 0 || byArray[n2 + n + 1] != 0 || (byArray[n2 + n + 2] & 0xFC) != 128) {
                return false;
            }
            int n3 = byArray[n2 + n + 4] >> 2 & 7;
            int n4 = RawPushBufferParser.this.h263Widths[n3];
            int n5 = RawPushBufferParser.this.h263Heights[n3];
            this.format = new VideoFormat("h263/rtp", new Dimension(n4, n5), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findJPEGKey(Buffer buffer) {
            if ((buffer.getFlags() & 0x800) == 0) {
                return false;
            }
            byte[] byArray = (byte[])buffer.getData();
            int n = (byArray[buffer.getOffset() + 6] & 0xFF) * 8;
            int n2 = (byArray[buffer.getOffset() + 7] & 0xFF) * 8;
            this.format = new VideoFormat("jpeg/rtp", new Dimension(n, n2), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), ((VideoFormat)this.format).getFrameRate());
            buffer.setFormat(this.format);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean findKeyFrame(Buffer buffer) {
            Cloneable cloneable;
            if (!this.checkDepacketizer) {
                cloneable = PlugInManager.getPlugInList(buffer.getFormat(), null, 6);
                if (((Vector)cloneable).size() != 0) {
                    this.depacketizer = this.findDepacketizer((String)((Vector)cloneable).elementAt(0), buffer.getFormat());
                }
                this.checkDepacketizer = true;
            }
            if ((cloneable = buffer.getFormat()) == null) {
                return false;
            }
            if (((Format)cloneable).getEncoding() == null) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
                return true;
            }
            boolean bl = true;
            if (jpegVideo.matches((Format)cloneable)) {
                bl = this.findJPEGKey(buffer);
            } else if (h261Video.matches((Format)cloneable)) {
                bl = this.findH261Key(buffer);
            } else if (h263Video.matches((Format)cloneable)) {
                bl = this.findH263Key(buffer);
            } else if (mpegVideo.matches((Format)cloneable)) {
                bl = this.findMPEGKey(buffer);
            } else if (mpegAudio.matches((Format)cloneable)) {
                bl = this.findMPAKey(buffer);
            } else if (this.depacketizer != null) {
                cloneable = this.depacketizer.parse(buffer);
                if (cloneable != null) {
                    this.format = cloneable;
                    buffer.setFormat(this.format);
                    this.depacketizer.close();
                    this.depacketizer = null;
                } else {
                    bl = false;
                }
            }
            if (bl) {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    this.keyFrameFound = true;
                    this.keyFrameLock.notifyAll();
                }
            }
            return this.keyFrameFound;
        }

        public boolean findMPAKey(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n = buffer.getOffset();
            if (buffer.getLength() < 8) {
                return false;
            }
            if (byArray[n + 2] != 0 || byArray[n + 3] != 0) {
                return false;
            }
            if ((byArray[n += 4] & 0xFF) != 255 || (byArray[n + 1] & 0xF6) <= 240 || (byArray[n + 2] & 0xF0) == 240 || (byArray[n + 2] & 0xC) == 12 || (byArray[n + 3] & 3) == 2) {
                return false;
            }
            int n2 = byArray[n + 1] >> 3 & 1;
            int n3 = byArray[n + 2] >> 2 & 3;
            int n4 = (byArray[n + 3] >> 6 & 3) == 3 ? 1 : 2;
            double d = MPASampleTbl[n2][n3];
            this.format = new AudioFormat("mpegaudio/rtp", d, 16, n4, 0, 1);
            buffer.setFormat(this.format);
            return true;
        }

        public boolean findMPEGKey(Buffer buffer) {
            byte[] byArray = (byte[])buffer.getData();
            if (byArray == null) {
                return false;
            }
            int n = buffer.getOffset();
            if (buffer.getLength() < 12) {
                return false;
            }
            if ((byArray[n + 2] & 0x20) != 32) {
                return false;
            }
            if (byArray[n + 4] != 0 || byArray[n + 5] != 0 || byArray[n + 6] != 1 || (byArray[n + 7] & 0xFF) != 179) {
                return false;
            }
            int n2 = byArray[n + 11] & 0xF;
            if (n2 == 0 || n2 > 8) {
                return false;
            }
            int n3 = (byArray[n + 8] & 0xFF) << 4 | (byArray[n + 9] & 0xF0) >> 4;
            int n4 = (byArray[n + 9] & 0xF) << 8 | byArray[n + 10] & 0xFF;
            float f = RawPushBufferParser.this.MPEGRateTbl[n2];
            this.format = new VideoFormat("mpeg/rtp", new Dimension(n3, n4), ((VideoFormat)this.format).getMaxDataLength(), ((VideoFormat)this.format).getDataType(), f);
            buffer.setFormat(this.format);
            return true;
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        int getH263PayloadHeaderLength(byte[] byArray, int n) {
            int n2 = 0;
            byte by = byArray[n];
            n2 = (by & 0x80) != 0 ? ((by & 0x40) != 0 ? 12 : 8) : 4;
            return n2;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time time) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse() {
            try {
                Object object = this.keyFrameLock;
                synchronized (object) {
                    while (!this.keyFrameFound) {
                        this.keyFrameLock.wait();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Buffer buffer2;
            if (this.stopped) {
                buffer.setDiscard(true);
                buffer.setFormat(this.format);
                return;
            }
            Object object = this.bufferQ;
            synchronized (object) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        if (!this.stopped) continue;
                        buffer.setDiscard(true);
                        buffer.setFormat(this.format);
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
                buffer2 = this.bufferQ.read();
            }
            object = buffer.getHeader();
            buffer.copy(buffer2, true);
            buffer2.setHeader(object);
            this.format = buffer2.getFormat();
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        public void reset() {
        }

        public void setEnabled(boolean bl) {
            if (bl) {
                this.pbs.setTransferHandler(this);
            } else {
                this.pbs.setTransferHandler(null);
            }
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = false;
                if (RawPushBufferParser.this.source instanceof CaptureDevice) {
                    while (this.bufferQ.canRead()) {
                        this.bufferQ.read();
                        this.bufferQ.readReport();
                    }
                }
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.stopped = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushBufferStream pushBufferStream) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!(this.bufferQ.canWrite() || this.closed || this.stopped)) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception exception) {}
                }
                if (this.closed || this.stopped) {
                    return;
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            try {
                pushBufferStream.read(buffer);
            }
            catch (IOException iOException) {
                buffer.setDiscard(true);
            }
            if (!this.keyFrameFound && !this.findKeyFrame(buffer)) {
                circularBuffer = this.bufferQ;
                synchronized (circularBuffer) {
                    this.bufferQ.writeReport();
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                return;
            }
            circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
        }
    }
}

