/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jitsi.impl.neomedia.codec.audio.g729.Bits;
import org.jitsi.impl.neomedia.codec.audio.g729.CodLd8k;
import org.jitsi.impl.neomedia.codec.audio.g729.Ld8k;
import org.jitsi.impl.neomedia.codec.audio.g729.PreProc;
import org.jitsi.impl.neomedia.codec.audio.g729.Util;

class Coder
extends Ld8k {
    private final PreProc preProc = new PreProc();
    private final CodLd8k codLd8k = new CodLd8k();
    private final int[] prm = new int[11];

    Coder() {
        this.preProc.init_pre_process();
        this.codLd8k.init_coder_ld8k();
    }

    public static void main(String[] args) throws IOException {
        FileOutputStream f_serial;
        FileInputStream f_speech;
        short[] sp16 = new short[80];
        short[] serial = new short[82];
        System.out.printf("\n", new Object[0]);
        System.out.printf("************  ITU G.729  8 Kbit/S SPEECH CODER  **************\n", new Object[0]);
        System.out.printf("\n", new Object[0]);
        System.out.printf("----------------- Floating point C simulation ----------------\n", new Object[0]);
        System.out.printf("\n", new Object[0]);
        System.out.printf("------------ Version 1.01 (Release 2, November 2006) --------\n", new Object[0]);
        System.out.printf("\n", new Object[0]);
        if (args.length != 2) {
            System.out.printf("Usage : coder  speech_file  bitstream_file \n", new Object[0]);
            System.out.printf("\n", new Object[0]);
            System.out.printf("Format for speech_file:\n", new Object[0]);
            System.out.printf("  Speech is read form a binary file of 16 bits data.\n", new Object[0]);
            System.out.printf("\n", new Object[0]);
            System.out.printf("Format for bitstream_file:\n", new Object[0]);
            System.out.printf("  One word (2-bytes) to indicate erasure.\n", new Object[0]);
            System.out.printf("  One word (2 bytes) to indicate bit rate\n", new Object[0]);
            System.out.printf("  80 words (2-bytes) containing 80 bits.\n", new Object[0]);
            System.out.printf("\n", new Object[0]);
            System.exit(1);
        }
        try {
            f_speech = new FileInputStream(args[0]);
        }
        catch (IOException ex) {
            System.out.printf("Codder - Error opening file  %s !!\n", args[0]);
            System.exit(0);
            throw ex;
        }
        System.out.printf(" Input speech file     :  %s\n", args[0]);
        try {
            f_serial = new FileOutputStream(args[1]);
        }
        catch (IOException ex) {
            System.out.printf("Coder - Error opening file  %s !!\n", args[1]);
            System.exit(0);
            throw ex;
        }
        System.out.printf(" Output bitstream file :  %s\n", args[1]);
        Coder coder = new Coder();
        int frame = 0;
        while (Util.fread(sp16, 80, f_speech) == 80) {
            System.out.printf(" Frame: %d\r", ++frame);
            coder.process(sp16, serial);
            Util.fwrite(serial, 82, f_serial);
        }
        ((OutputStream)f_serial).close();
        ((InputStream)f_speech).close();
    }

    void process(short[] sp16, short[] serial) {
        float[] new_speech = this.codLd8k.new_speech;
        int new_speech_offset = this.codLd8k.new_speech_offset;
        for (int i = 0; i < 80; ++i) {
            new_speech[new_speech_offset + i] = sp16[i];
        }
        this.preProc.pre_process(new_speech, new_speech_offset, 80);
        this.codLd8k.coder_ld8k(this.prm);
        Bits.prm2bits_ld8k(this.prm, serial);
    }
}

